/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.http.impl.client;

import ar.apache.http.HttpConnection;
import ar.apache.http.annotation.Immutable;
import ar.apache.http.auth.AuthScheme;
import ar.apache.http.auth.AuthState;
import ar.apache.http.auth.Credentials;
import ar.apache.http.client.UserTokenHandler;
import ar.apache.http.client.protocol.HttpClientContext;
import ar.apache.http.conn.ManagedHttpClientConnection;
import ar.apache.http.protocol.HttpContext;
import java.security.Principal;
import javax.net.ssl.SSLSession;

@Immutable
public class DefaultUserTokenHandler
implements UserTokenHandler {
    public static final DefaultUserTokenHandler INSTANCE = new DefaultUserTokenHandler();

    @Override
    public Object getUserToken(HttpContext context) {
        SSLSession sslsession;
        HttpConnection conn;
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        Principal userPrincipal = null;
        AuthState targetAuthState = clientContext.getTargetAuthState();
        if (targetAuthState != null && (userPrincipal = DefaultUserTokenHandler.getAuthPrincipal(targetAuthState)) == null) {
            AuthState proxyAuthState = clientContext.getProxyAuthState();
            userPrincipal = DefaultUserTokenHandler.getAuthPrincipal(proxyAuthState);
        }
        if (userPrincipal == null && (conn = clientContext.getConnection()).isOpen() && conn instanceof ManagedHttpClientConnection && (sslsession = ((ManagedHttpClientConnection)conn).getSSLSession()) != null) {
            userPrincipal = sslsession.getLocalPrincipal();
        }
        return userPrincipal;
    }

    private static Principal getAuthPrincipal(AuthState authState) {
        Credentials creds;
        AuthScheme scheme = authState.getAuthScheme();
        if (scheme != null && scheme.isComplete() && scheme.isConnectionBased() && (creds = authState.getCredentials()) != null) {
            return creds.getUserPrincipal();
        }
        return null;
    }
}

