/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.http.impl.client;

import ar.apache.http.HttpException;
import ar.apache.http.HttpHost;
import ar.apache.http.HttpRequest;
import ar.apache.http.annotation.ThreadSafe;
import ar.apache.http.client.ClientProtocolException;
import ar.apache.http.client.config.RequestConfig;
import ar.apache.http.client.methods.CloseableHttpResponse;
import ar.apache.http.client.methods.Configurable;
import ar.apache.http.client.methods.HttpExecutionAware;
import ar.apache.http.client.methods.HttpRequestWrapper;
import ar.apache.http.client.protocol.HttpClientContext;
import ar.apache.http.conn.ClientConnectionManager;
import ar.apache.http.conn.ClientConnectionRequest;
import ar.apache.http.conn.HttpClientConnectionManager;
import ar.apache.http.conn.ManagedClientConnection;
import ar.apache.http.conn.routing.HttpRoute;
import ar.apache.http.conn.scheme.SchemeRegistry;
import ar.apache.http.impl.DefaultConnectionReuseStrategy;
import ar.apache.http.impl.client.CloseableHttpClient;
import ar.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import ar.apache.http.impl.execchain.MinimalClientExec;
import ar.apache.http.params.BasicHttpParams;
import ar.apache.http.params.HttpParams;
import ar.apache.http.protocol.BasicHttpContext;
import ar.apache.http.protocol.HttpContext;
import ar.apache.http.protocol.HttpRequestExecutor;
import ar.apache.http.util.Args;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@ThreadSafe
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            try {
                return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    @Override
    public HttpParams getParams() {
        return this.params;
    }

    @Override
    public void close() {
        this.connManager.shutdown();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            @Override
            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            @Override
            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void closeIdleConnections(long idletime, TimeUnit tunit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, tunit);
            }

            @Override
            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

