/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.http.impl.conn;

import ar.apache.http.HttpConnectionMetrics;
import ar.apache.http.HttpEntityEnclosingRequest;
import ar.apache.http.HttpException;
import ar.apache.http.HttpRequest;
import ar.apache.http.HttpResponse;
import ar.apache.http.annotation.NotThreadSafe;
import ar.apache.http.conn.ClientConnectionManager;
import ar.apache.http.conn.ManagedClientConnection;
import ar.apache.http.conn.OperatedClientConnection;
import ar.apache.http.impl.conn.ConnectionShutdownException;
import ar.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

@Deprecated
@NotThreadSafe
public abstract class AbstractClientConnAdapter
implements ManagedClientConnection,
HttpContext {
    private final ClientConnectionManager connManager;
    private volatile OperatedClientConnection wrappedConnection;
    private volatile boolean markedReusable;
    private volatile boolean released;
    private volatile long duration;

    protected AbstractClientConnAdapter(ClientConnectionManager mgr, OperatedClientConnection conn) {
        this.connManager = mgr;
        this.wrappedConnection = conn;
        this.markedReusable = false;
        this.released = false;
        this.duration = Long.MAX_VALUE;
    }

    protected synchronized void detach() {
        this.wrappedConnection = null;
        this.duration = Long.MAX_VALUE;
    }

    protected OperatedClientConnection getWrappedConnection() {
        return this.wrappedConnection;
    }

    protected ClientConnectionManager getManager() {
        return this.connManager;
    }

    @Deprecated
    protected final void assertNotAborted() throws InterruptedIOException {
        if (this.isReleased()) {
            throw new InterruptedIOException("Connection has been shut down");
        }
    }

    protected boolean isReleased() {
        return this.released;
    }

    protected final void assertValid(OperatedClientConnection wrappedConn) throws ConnectionShutdownException {
        if (this.isReleased() || wrappedConn == null) {
            throw new ConnectionShutdownException();
        }
    }

    @Override
    public boolean isOpen() {
        OperatedClientConnection conn = this.getWrappedConnection();
        if (conn == null) {
            return false;
        }
        return conn.isOpen();
    }

    @Override
    public boolean isStale() {
        if (this.isReleased()) {
            return true;
        }
        OperatedClientConnection conn = this.getWrappedConnection();
        if (conn == null) {
            return true;
        }
        return conn.isStale();
    }

    @Override
    public void setSocketTimeout(int timeout) {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        conn.setSocketTimeout(timeout);
    }

    @Override
    public int getSocketTimeout() {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        return conn.getSocketTimeout();
    }

    @Override
    public HttpConnectionMetrics getMetrics() {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        return conn.getMetrics();
    }

    @Override
    public void flush() {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        try {
            conn.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isResponseAvailable(int timeout) {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        try {
            return conn.isResponseAvailable(timeout);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void receiveResponseEntity(HttpResponse response) throws HttpException {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        this.unmarkReusable();
        try {
            conn.receiveResponseEntity(response);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public HttpResponse receiveResponseHeader() throws HttpException {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        this.unmarkReusable();
        try {
            return conn.receiveResponseHeader();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        this.unmarkReusable();
        try {
            conn.sendRequestEntity(request);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendRequestHeader(HttpRequest request) throws HttpException {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        this.unmarkReusable();
        try {
            conn.sendRequestHeader(request);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public InetAddress getLocalAddress() {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        return conn.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        return conn.getLocalPort();
    }

    @Override
    public InetAddress getRemoteAddress() {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        return conn.getRemoteAddress();
    }

    @Override
    public int getRemotePort() {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        return conn.getRemotePort();
    }

    @Override
    public boolean isSecure() {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        return conn.isSecure();
    }

    @Override
    public void bind(Socket socket) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket getSocket() {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        if (!this.isOpen()) {
            return null;
        }
        return conn.getSocket();
    }

    @Override
    public SSLSession getSSLSession() {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        if (!this.isOpen()) {
            return null;
        }
        SSLSession result = null;
        Socket sock = conn.getSocket();
        if (sock instanceof SSLSocket) {
            result = ((SSLSocket)sock).getSession();
        }
        return result;
    }

    @Override
    public void markReusable() {
        this.markedReusable = true;
    }

    @Override
    public void unmarkReusable() {
        this.markedReusable = false;
    }

    @Override
    public boolean isMarkedReusable() {
        return this.markedReusable;
    }

    @Override
    public void setIdleDuration(long duration, TimeUnit unit) {
        this.duration = duration > 0L ? unit.toMillis(duration) : -1L;
    }

    @Override
    public synchronized void releaseConnection() {
        if (this.released) {
            return;
        }
        this.released = true;
        this.connManager.releaseConnection(this, this.duration, TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized void abortConnection() {
        if (this.released) {
            return;
        }
        this.released = true;
        this.unmarkReusable();
        try {
            this.shutdown();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.connManager.releaseConnection(this, this.duration, TimeUnit.MILLISECONDS);
    }

    @Override
    public Object getAttribute(String id) {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        if (conn instanceof HttpContext) {
            return ((HttpContext)((Object)conn)).getAttribute(id);
        }
        return null;
    }

    @Override
    public Object removeAttribute(String id) {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        if (conn instanceof HttpContext) {
            return ((HttpContext)((Object)conn)).removeAttribute(id);
        }
        return null;
    }

    @Override
    public void setAttribute(String id, Object obj) {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        if (conn instanceof HttpContext) {
            ((HttpContext)((Object)conn)).setAttribute(id, obj);
        }
    }
}

