/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.http.impl.conn;

import ar.apache.commons.logging.Log;
import ar.apache.http.HttpClientConnection;
import ar.apache.http.annotation.ThreadSafe;
import ar.apache.http.conn.ManagedHttpClientConnection;
import ar.apache.http.conn.routing.HttpRoute;
import ar.apache.http.pool.PoolEntry;
import java.util.Date;
import java.util.concurrent.TimeUnit;

@ThreadSafe
class CPoolEntry
extends PoolEntry<HttpRoute, ManagedHttpClientConnection> {
    private final Log log;
    private volatile boolean routeComplete;

    public CPoolEntry(Log log, String id, HttpRoute route, ManagedHttpClientConnection conn, long timeToLive, TimeUnit tunit) {
        super(id, route, conn, timeToLive, tunit);
        this.log = log;
    }

    public void markRouteComplete() {
        this.routeComplete = true;
    }

    public boolean isRouteComplete() {
        return this.routeComplete;
    }

    public void closeConnection() throws Exception {
        HttpClientConnection conn = (HttpClientConnection)this.getConnection();
        conn.close();
    }

    public void shutdownConnection() throws Exception {
        HttpClientConnection conn = (HttpClientConnection)this.getConnection();
        conn.shutdown();
    }

    @Override
    public boolean isExpired(long now) {
        boolean expired = super.isExpired(now);
        if (expired && this.log.isDebugEnabled()) {
            this.log.debug("Connection " + this + " expired @ " + new Date(this.getExpiry()));
        }
        return expired;
    }

    @Override
    public boolean isClosed() {
        HttpClientConnection conn = (HttpClientConnection)this.getConnection();
        return !conn.isOpen();
    }

    @Override
    public void close() {
        try {
            this.closeConnection();
        }
        catch (Exception ex) {
            this.log.debug("I/O error closing connection", ex);
        }
    }
}

