/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.http.impl.conn;

import ar.apache.http.HttpResponse;
import ar.apache.http.HttpResponseFactory;
import ar.apache.http.annotation.Immutable;
import ar.apache.http.config.MessageConstraints;
import ar.apache.http.impl.DefaultHttpResponseFactory;
import ar.apache.http.impl.conn.DefaultHttpResponseParser;
import ar.apache.http.io.HttpMessageParser;
import ar.apache.http.io.HttpMessageParserFactory;
import ar.apache.http.io.SessionInputBuffer;
import ar.apache.http.message.BasicLineParser;
import ar.apache.http.message.LineParser;

@Immutable
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(HttpResponseFactory responseFactory) {
        this(null, responseFactory);
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

