/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.http.protocol;

import ar.apache.http.HttpConnection;
import ar.apache.http.HttpException;
import ar.apache.http.HttpHost;
import ar.apache.http.HttpInetConnection;
import ar.apache.http.HttpRequest;
import ar.apache.http.HttpRequestInterceptor;
import ar.apache.http.HttpVersion;
import ar.apache.http.ProtocolException;
import ar.apache.http.ProtocolVersion;
import ar.apache.http.annotation.Immutable;
import ar.apache.http.protocol.HttpContext;
import ar.apache.http.protocol.HttpCoreContext;
import ar.apache.http.util.Args;
import java.io.IOException;
import java.net.InetAddress;

@Immutable
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext corecontext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targethost = corecontext.getTargetHost();
            if (targethost == null) {
                HttpConnection conn = corecontext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targethost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targethost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targethost.toHostString());
        }
    }
}

