/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.log.format;

import ar.apache.log.ContextMap;
import ar.apache.log.LogEvent;
import ar.apache.log.Logger;
import ar.apache.log.format.PatternFormatter;
import ar.apache.log.util.StackIntrospector;

public class ExtendedPatternFormatter
extends PatternFormatter {
    private static final int TYPE_METHOD = 9;
    private static final int TYPE_THREAD = 10;
    private static final String TYPE_METHOD_STR = "method";
    private static final String TYPE_THREAD_STR = "thread";

    public ExtendedPatternFormatter(String format) {
        super(format);
    }

    @Override
    protected int getTypeIdFor(String type2) {
        if (type2.equalsIgnoreCase(TYPE_METHOD_STR)) {
            return 9;
        }
        if (type2.equalsIgnoreCase(TYPE_THREAD_STR)) {
            return 10;
        }
        return super.getTypeIdFor(type2);
    }

    @Override
    protected String formatPatternRun(LogEvent event, PatternFormatter.PatternRun run) {
        switch (run.m_type) {
            case 9: {
                return this.getMethod(event, run.m_format);
            }
            case 10: {
                return this.getThread(event, run.m_format);
            }
        }
        return super.formatPatternRun(event, run);
    }

    private String getMethod(LogEvent event, String format) {
        Object object;
        ContextMap map = event.getContextMap();
        if (null != map && null != (object = map.get(TYPE_METHOD_STR))) {
            return object.toString();
        }
        String result = StackIntrospector.getCallerMethod(Logger.class);
        if (null == result) {
            return "UnknownMethod";
        }
        return result;
    }

    private String getThread(LogEvent event, String format) {
        Object object;
        ContextMap map = event.getContextMap();
        if (null != map && null != (object = map.get(TYPE_THREAD_STR))) {
            return object.toString();
        }
        return Thread.currentThread().getName();
    }
}

