/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.log.output;

import ar.apache.log.ErrorAware;
import ar.apache.log.ErrorHandler;
import ar.apache.log.LogEvent;
import ar.apache.log.LogTarget;

public abstract class AbstractTarget
implements LogTarget,
ErrorAware {
    private ErrorHandler m_errorHandler;
    private boolean m_isOpen;

    @Override
    public synchronized void setErrorHandler(ErrorHandler errorHandler) {
        this.m_errorHandler = errorHandler;
    }

    protected synchronized boolean isOpen() {
        return this.m_isOpen;
    }

    protected synchronized void open() {
        if (!this.isOpen()) {
            this.m_isOpen = true;
        }
    }

    @Override
    public synchronized void processEvent(LogEvent event) {
        if (!this.isOpen()) {
            this.getErrorHandler().error("Writing event to closed stream.", null, event);
            return;
        }
        try {
            this.doProcessEvent(event);
        }
        catch (Throwable throwable) {
            this.getErrorHandler().error("Unknown error writing event.", throwable, event);
        }
    }

    protected abstract void doProcessEvent(LogEvent var1) throws Exception;

    public synchronized void close() {
        if (this.isOpen()) {
            this.m_isOpen = false;
        }
    }

    protected final ErrorHandler getErrorHandler() {
        return this.m_errorHandler;
    }

    protected final void error(String message, Throwable throwable) {
        this.getErrorHandler().error(message, throwable, null);
    }
}

