/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.log.output.db;

import ar.apache.log.LogEvent;
import ar.apache.log.output.AbstractTarget;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public abstract class AbstractJDBCTarget
extends AbstractTarget {
    private DataSource m_dataSource;
    private Connection m_connection;

    protected AbstractJDBCTarget(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    @Override
    protected synchronized void doProcessEvent(LogEvent event) throws Exception {
        this.checkConnection();
        if (this.isOpen()) {
            this.output(event);
        }
    }

    protected abstract void output(LogEvent var1);

    @Override
    protected synchronized void open() {
        if (!this.isOpen()) {
            super.open();
            this.openConnection();
        }
    }

    protected synchronized void openConnection() {
        try {
            this.m_connection = this.m_dataSource.getConnection();
        }
        catch (Throwable throwable) {
            this.getErrorHandler().error("Unable to open connection", throwable, null);
        }
    }

    protected final synchronized Connection getConnection() {
        return this.m_connection;
    }

    protected final synchronized void checkConnection() {
        if (this.isStale()) {
            this.closeConnection();
            this.openConnection();
        }
    }

    protected synchronized boolean isStale() {
        if (null == this.m_connection) {
            return true;
        }
        try {
            if (this.m_connection.isClosed()) {
                return true;
            }
        }
        catch (SQLException se) {
            return true;
        }
        return false;
    }

    @Override
    public synchronized void close() {
        if (this.isOpen()) {
            this.closeConnection();
            super.close();
        }
    }

    protected synchronized void closeConnection() {
        if (null != this.m_connection) {
            try {
                this.m_connection.close();
            }
            catch (SQLException se) {
                this.getErrorHandler().error("Error shutting down JDBC connection", se, null);
            }
            this.m_connection = null;
        }
    }
}

