/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.log.output.jms;

import ar.apache.log.output.jms.AbstractJMSTarget;
import ar.apache.log.output.jms.MessageBuilder;
import ar.jms.Message;
import ar.jms.Queue;
import ar.jms.QueueConnection;
import ar.jms.QueueConnectionFactory;
import ar.jms.QueueSender;
import ar.jms.QueueSession;
import ar.jms.Session;

public class JMSQueueTarget
extends AbstractJMSTarget {
    private QueueConnectionFactory m_factory;
    private Queue m_queue;
    private QueueSession m_session;
    private QueueSender m_sender;
    private QueueConnection m_connection;

    public JMSQueueTarget(MessageBuilder builder, QueueConnectionFactory factory, Queue queue) {
        super(builder);
        this.m_factory = factory;
        this.m_queue = queue;
        this.open();
    }

    @Override
    protected void send(Message message) {
        try {
            this.m_sender.send(message);
        }
        catch (Exception e) {
            this.getErrorHandler().error("Error publishing message", e, null);
        }
    }

    @Override
    protected Session getSession() {
        return this.m_session;
    }

    @Override
    protected synchronized void openConnection() {
        try {
            this.m_connection = this.m_factory.createQueueConnection();
            this.m_connection.start();
            this.m_session = this.m_connection.createQueueSession(false, 1);
            this.m_sender = this.m_session.createSender(this.m_queue);
        }
        catch (Exception e) {
            this.getErrorHandler().error("Error starting connection", e, null);
        }
    }

    @Override
    protected synchronized void closeConnection() {
        try {
            if (null != this.m_sender) {
                this.m_sender.close();
            }
            if (null != this.m_session) {
                this.m_session.close();
            }
            if (null != this.m_connection) {
                this.m_connection.close();
            }
        }
        catch (Exception e) {
            this.getErrorHandler().error("Error closing connection", e, null);
        }
        this.m_sender = null;
        this.m_session = null;
        this.m_connection = null;
    }
}

