/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.mercadopago.core;

import ar.apache.commons.validator.UrlValidator;
import ar.com.sdd.mercadopago.core.MPBase;
import ar.com.sdd.mercadopago.exceptions.MPException;
import ar.google.gson.FieldNamingPolicy;
import ar.google.gson.Gson;
import ar.google.gson.GsonBuilder;
import ar.google.gson.JsonArray;
import ar.google.gson.JsonElement;
import ar.google.gson.JsonObject;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class MPCoreUtils {
    private static final String FORMAT_ISO8601 = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    static Field[] getAllFields(Class<?> type2) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> clazz = type2; clazz != null && clazz != MPBase.class && clazz != Object.class; clazz = clazz.getSuperclass()) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        Field[] fieldsArray = new Field[fields.size()];
        return fields.toArray(fieldsArray);
    }

    public static <T extends MPBase> JsonObject getJsonFromResource(T resourceObject) {
        return (JsonObject)gson.toJsonTree(resourceObject);
    }

    public static <T> T getResourceFromJson(Class clazz, JsonObject jsonEntity) {
        return gson.fromJson((JsonElement)jsonEntity, clazz);
    }

    public static String inputStreamToString(InputStream is) throws MPException {
        String value = "";
        if (is != null) {
            try {
                int length;
                ByteArrayOutputStream result = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((length = is.read(buffer)) != -1) {
                    result.write(buffer, 0, length);
                }
                value = result.toString("UTF-8");
            }
            catch (Exception ex) {
                throw new MPException(ex);
            }
        }
        return value;
    }

    public static boolean validateUrl(String url) {
        String[] schemes = new String[]{"https"};
        UrlValidator urlValidator = new UrlValidator(schemes);
        return urlValidator.isValid(url);
    }

    static JsonArray getArrayFromJsonElement(JsonElement jsonElement) {
        JsonArray jsonArray = null;
        if (jsonElement.isJsonArray()) {
            jsonArray = jsonElement.getAsJsonArray();
        } else if (jsonElement.isJsonObject() && ((JsonObject)jsonElement).get("results") != null && ((JsonObject)jsonElement).get("results").isJsonArray()) {
            jsonArray = ((JsonObject)jsonElement).get("results").getAsJsonArray();
        }
        return jsonArray;
    }
}

