/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.mercadopago.net;

import ar.apache.commons.lang3.StringUtils;
import ar.apache.http.Header;
import ar.apache.http.HttpEntity;
import ar.apache.http.HttpHost;
import ar.apache.http.HttpResponse;
import ar.apache.http.client.ClientProtocolException;
import ar.apache.http.client.HttpClient;
import ar.apache.http.client.entity.UrlEncodedFormEntity;
import ar.apache.http.client.methods.HttpDelete;
import ar.apache.http.client.methods.HttpGet;
import ar.apache.http.client.methods.HttpPost;
import ar.apache.http.client.methods.HttpPut;
import ar.apache.http.client.methods.HttpRequestBase;
import ar.apache.http.entity.StringEntity;
import ar.apache.http.impl.client.AbstractHttpClient;
import ar.apache.http.impl.client.DefaultHttpClient;
import ar.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import ar.apache.http.message.BasicHeader;
import ar.apache.http.message.BasicHttpResponse;
import ar.apache.http.message.BasicNameValuePair;
import ar.apache.http.message.BasicStatusLine;
import ar.apache.http.params.HttpParams;
import ar.com.sdd.mercadopago.core.MPApiResponse;
import ar.com.sdd.mercadopago.core.annotations.rest.PayloadType;
import ar.com.sdd.mercadopago.exceptions.MPRestException;
import ar.com.sdd.mercadopago.net.HttpMethod;
import ar.google.gson.Gson;
import ar.google.gson.JsonObject;
import ar.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Vector;
import javax.net.ssl.SSLPeerUnverifiedException;

public class MPRestClient {
    private static String proxyHostName = null;
    private static int proxyPort = -1;

    public MPRestClient() {
        new MPRestClient(null, -1);
    }

    public MPRestClient(String proxyHostName, int proxyPort) {
        MPRestClient.proxyHostName = proxyHostName;
        MPRestClient.proxyPort = proxyPort;
    }

    public MPApiResponse executeRequest(HttpMethod httpMethod, String uri, PayloadType payloadType, JsonObject payload, Collection<Header> colHeaders) throws MPRestException {
        return this.executeRequest(httpMethod, uri, payloadType, payload, colHeaders, 0, 0, 0);
    }

    public MPApiResponse executeRequest(HttpMethod httpMethod, String uri, PayloadType payloadType, JsonObject payload, Collection<Header> colHeaders, int retries, int connectionTimeout, int socketTimeout) throws MPRestException {
        HttpClient httpClient = null;
        try {
            MPApiResponse mapiresponse;
            HttpResponse response;
            httpClient = this.getClient(retries, connectionTimeout, socketTimeout);
            if (colHeaders == null) {
                colHeaders = new Vector<Header>();
            }
            HttpEntity entity = this.normalizePayload(payloadType, payload, colHeaders);
            HttpRequestBase request = this.getRequestMethod(httpMethod, uri, entity);
            for (Header header : colHeaders) {
                request.addHeader(header);
            }
            long startMillis = System.currentTimeMillis();
            try {
                response = httpClient.execute(request);
            }
            catch (ClientProtocolException e) {
                response = new BasicHttpResponse(new BasicStatusLine(request.getProtocolVersion(), 400, null));
            }
            catch (SSLPeerUnverifiedException e) {
                response = new BasicHttpResponse(new BasicStatusLine(request.getProtocolVersion(), 403, null));
            }
            catch (IOException e) {
                response = new BasicHttpResponse(new BasicStatusLine(request.getProtocolVersion(), 404, null));
            }
            long endMillis = System.currentTimeMillis();
            long responseMillis = endMillis - startMillis;
            MPApiResponse mPApiResponse = mapiresponse = new MPApiResponse(httpMethod, request, payload, response, responseMillis);
            return mPApiResponse;
        }
        catch (MPRestException restEx) {
            throw restEx;
        }
        catch (Exception ex) {
            throw new MPRestException(ex);
        }
        finally {
            try {
                if (httpClient != null) {
                    httpClient.getConnectionManager().shutdown();
                }
            }
            catch (Exception exception) {}
        }
    }

    private HttpClient getClient(int retries, int connectionTimeout, int socketTimeout) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpParams httpParams = httpClient.getParams();
        if (retries > 0) {
            DefaultHttpRequestRetryHandler retryHandler = new DefaultHttpRequestRetryHandler(retries, true);
            ((AbstractHttpClient)httpClient).setHttpRequestRetryHandler(retryHandler);
        }
        if (connectionTimeout > 0) {
            httpParams.setParameter("http.connection.timeout", connectionTimeout);
        }
        if (socketTimeout > 0) {
            httpParams.setParameter("http.socket.timeout", socketTimeout);
        }
        if (StringUtils.isNotEmpty(proxyHostName)) {
            HttpHost proxy = new HttpHost(proxyHostName, proxyPort);
            httpParams.setParameter("http.route.default-proxy", proxy);
        }
        return httpClient;
    }

    private HttpEntity normalizePayload(PayloadType payloadType, JsonObject payload, Collection<Header> colHeaders) throws MPRestException {
        BasicHeader header = null;
        StringEntity entity = null;
        if (payload != null) {
            if (payloadType == PayloadType.JSON) {
                header = new BasicHeader("Content-Type", "application/json");
                StringEntity stringEntity = null;
                try {
                    stringEntity = new StringEntity(payload.toString());
                }
                catch (Exception ex) {
                    throw new MPRestException(ex);
                }
                stringEntity.setContentType(header);
                entity = stringEntity;
            } else {
                Map map = (Map)new Gson().fromJson(payload.toString(), new TypeToken<Map<String, Object>>(){}.getType());
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(2);
                for (Map.Entry entry : map.entrySet()) {
                    params.add(new BasicNameValuePair((String)entry.getKey(), entry.getValue().toString()));
                }
                UrlEncodedFormEntity urlEncodedFormEntity = null;
                try {
                    urlEncodedFormEntity = new UrlEncodedFormEntity(params, "UTF-8");
                }
                catch (Exception ex) {
                    throw new MPRestException(ex);
                }
                header = new BasicHeader("Content-Type", "application/x-www-form-urlencoded");
                urlEncodedFormEntity.setContentType(header);
                entity = urlEncodedFormEntity;
            }
        }
        if (header != null) {
            colHeaders.add(header);
        }
        return entity;
    }

    private HttpRequestBase getRequestMethod(HttpMethod httpMethod, String uri, HttpEntity entity) throws MPRestException {
        if (httpMethod == null) {
            throw new MPRestException("HttpMethod must be \"GET\", \"POST\", \"PUT\" or \"DELETE\".");
        }
        if (StringUtils.isEmpty(uri)) {
            throw new MPRestException("Uri can not be an empty String.");
        }
        HttpRequestBase request = null;
        if (httpMethod.equals((Object)HttpMethod.GET)) {
            if (entity != null) {
                throw new MPRestException("Payload not supported for this method.");
            }
            request = new HttpGet(uri);
        } else if (httpMethod.equals((Object)HttpMethod.POST)) {
            if (entity == null) {
                throw new MPRestException("Must include payload for this method.");
            }
            HttpPost post = new HttpPost(uri);
            post.setEntity(entity);
            request = post;
        } else if (httpMethod.equals((Object)HttpMethod.PUT)) {
            if (entity == null) {
                throw new MPRestException("Must include payload for this method.");
            }
            HttpPut put = new HttpPut(uri);
            put.setEntity(entity);
            request = put;
        } else if (httpMethod.equals((Object)HttpMethod.DELETE)) {
            if (entity != null) {
                throw new MPRestException("Payload not supported for this method.");
            }
            request = new HttpDelete(uri);
        }
        return request;
    }
}

