/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.mercadopago.resources.datastructures.preference;

import ar.com.sdd.mercadopago.core.annotations.validation.Numeric;
import ar.com.sdd.mercadopago.resources.datastructures.preference.AddressReceiver;
import ar.com.sdd.mercadopago.resources.datastructures.preference.ShippingMethod;
import java.util.ArrayList;

public class Shipments {
    private ShipmentMode mode = null;
    private Boolean localPickup = null;
    private String dimensions = null;
    private Integer defaultShippingMethod = null;
    private ArrayList<ShippingMethod> freeMethods = null;
    @Numeric(min=0.01f)
    private Float cost = null;
    private Boolean freeShipping = null;
    private AddressReceiver receiverAddress = null;

    public AddressReceiver getReceiverAddress() {
        return this.receiverAddress;
    }

    public Shipments setReceiverAddress(AddressReceiver addressReceiver) {
        this.receiverAddress = addressReceiver;
        return this;
    }

    public ShipmentMode getMode() {
        return this.mode;
    }

    public Shipments setMode(ShipmentMode mode) {
        this.mode = mode;
        return this;
    }

    public Boolean getLocalPickup() {
        return this.localPickup;
    }

    public Shipments setLocalPickup(Boolean localPickup) {
        this.localPickup = localPickup;
        return this;
    }

    public String getDimensions() {
        return this.dimensions;
    }

    public Shipments setDimensions(String dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public Integer getDefaultShippingMethod() {
        return this.defaultShippingMethod;
    }

    public Shipments setDefaultShippingMethod(Integer defaultShippingMethod) {
        this.defaultShippingMethod = defaultShippingMethod;
        return this;
    }

    public ArrayList<ShippingMethod> getFreeMethods() {
        return this.freeMethods;
    }

    public Shipments setFreeMethods(ArrayList<ShippingMethod> freeMethods) {
        this.freeMethods = freeMethods;
        return this;
    }

    public Shipments setFreeMethods(int ... ids) {
        ArrayList<ShippingMethod> shippingMethods = new ArrayList<ShippingMethod>();
        for (int i = 0; i < ids.length; ++i) {
            ShippingMethod newShippingMethod = new ShippingMethod(ids[i]);
            shippingMethods.add(newShippingMethod);
        }
        this.freeMethods = shippingMethods;
        return this;
    }

    public ArrayList<ShippingMethod> appendFreeMethods(ShippingMethod freeMethod) {
        if (this.freeMethods == null) {
            this.freeMethods = new ArrayList();
        }
        this.freeMethods.add(freeMethod);
        return this.getFreeMethods();
    }

    public Float getCost() {
        return this.cost;
    }

    public Shipments setCost(Float cost) {
        this.cost = cost;
        return this;
    }

    public Boolean getFreeShipping() {
        return this.freeShipping;
    }

    public Shipments setFreeShipping(Boolean freeShipping) {
        this.freeShipping = freeShipping;
        return this;
    }

    public static enum ShipmentMode {
        custom,
        me2,
        not_specified;

    }
}

