/*
 * Decompiled with CFR 0.152.
 */
package ar.jms;

import ar.jms.InvalidDestinationException;
import ar.jms.JMSException;
import ar.jms.Message;
import ar.jms.Queue;
import ar.jms.QueueReceiver;
import ar.jms.QueueSender;
import ar.jms.QueueSession;
import ar.jms.TemporaryQueue;

public class QueueRequestor {
    QueueSession session;
    TemporaryQueue tempQueue;
    QueueSender sender;
    QueueReceiver receiver;

    public QueueRequestor(QueueSession session, Queue queue) throws JMSException {
        if (queue == null) {
            throw new InvalidDestinationException("queue==null");
        }
        this.session = session;
        this.tempQueue = session.createTemporaryQueue();
        this.sender = session.createSender(queue);
        this.receiver = session.createReceiver(this.tempQueue);
    }

    public Message request(Message message) throws JMSException {
        message.setJMSReplyTo(this.tempQueue);
        this.sender.send(message);
        return this.receiver.receive();
    }

    public void close() throws JMSException {
        this.session.close();
        this.tempQueue.delete();
    }
}

