/*
 * Decompiled with CFR 0.152.
 */
package ar.sun.jersey.core.impl.provider.entity;

import ar.mail.MessagingException;
import ar.mail.internet.MimeMultipart;
import ar.mail.internet.ParseException;
import ar.mail.util.ByteArrayDataSource;
import ar.sun.jersey.core.provider.AbstractMessageReaderWriterProvider;
import ar.ws.rs.WebApplicationException;
import ar.ws.rs.core.MediaType;
import ar.ws.rs.core.MultivaluedMap;
import ar.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

public final class MimeMultipartProvider
extends AbstractMessageReaderWriterProvider<MimeMultipart> {
    public MimeMultipartProvider() {
        Class<MimeMultipart> c = MimeMultipart.class;
    }

    @Override
    public boolean isReadable(Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type2 == MimeMultipart.class;
    }

    @Override
    public MimeMultipart readFrom(Class<MimeMultipart> type2, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        if (mediaType == null) {
            mediaType = new MediaType("multipart", "form-data");
        }
        ByteArrayDataSource ds = new ByteArrayDataSource(entityStream, mediaType.toString());
        try {
            return new MimeMultipart(ds);
        }
        catch (ParseException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.BAD_REQUEST);
        }
        catch (MessagingException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public boolean isWriteable(Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type2 == MimeMultipart.class;
    }

    @Override
    public void writeTo(MimeMultipart t, Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            t.writeTo(entityStream);
        }
        catch (MessagingException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

