/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.commons.beanutils;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

class WeakFastHashMap
extends HashMap {
    private Map map = null;
    private boolean fast = false;

    public WeakFastHashMap() {
        this.map = this.createMap();
    }

    public WeakFastHashMap(int capacity) {
        this.map = this.createMap(capacity);
    }

    public WeakFastHashMap(int capacity, float factor) {
        this.map = this.createMap(capacity, factor);
    }

    public WeakFastHashMap(Map map) {
        this.map = this.createMap(map);
    }

    public boolean getFast() {
        return this.fast;
    }

    public void setFast(boolean fast) {
        this.fast = fast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        if (this.fast) {
            return this.map.get(key);
        }
        Map map = this.map;
        synchronized (map) {
            return this.map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        if (this.fast) {
            return this.map.size();
        }
        Map map = this.map;
        synchronized (map) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        if (this.fast) {
            return this.map.isEmpty();
        }
        Map map = this.map;
        synchronized (map) {
            return this.map.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        if (this.fast) {
            return this.map.containsKey(key);
        }
        Map map = this.map;
        synchronized (map) {
            return this.map.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        if (this.fast) {
            return this.map.containsValue(value);
        }
        Map map = this.map;
        synchronized (map) {
            return this.map.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value) {
        if (this.fast) {
            WeakFastHashMap weakFastHashMap = this;
            synchronized (weakFastHashMap) {
                Map temp = this.cloneMap(this.map);
                Object result = temp.put(key, value);
                this.map = temp;
                return result;
            }
        }
        Map map = this.map;
        synchronized (map) {
            return this.map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map in) {
        if (this.fast) {
            WeakFastHashMap weakFastHashMap = this;
            synchronized (weakFastHashMap) {
                Map temp = this.cloneMap(this.map);
                temp.putAll(in);
                this.map = temp;
            }
        }
        Map map = this.map;
        synchronized (map) {
            this.map.putAll(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key) {
        if (this.fast) {
            WeakFastHashMap weakFastHashMap = this;
            synchronized (weakFastHashMap) {
                Map temp = this.cloneMap(this.map);
                Object result = temp.remove(key);
                this.map = temp;
                return result;
            }
        }
        Map map = this.map;
        synchronized (map) {
            return this.map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.fast) {
            WeakFastHashMap weakFastHashMap = this;
            synchronized (weakFastHashMap) {
                this.map = this.createMap();
            }
        }
        Map map = this.map;
        synchronized (map) {
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map mo = (Map)o;
        if (this.fast) {
            if (mo.size() != this.map.size()) {
                return false;
            }
            for (Map.Entry e : this.map.entrySet()) {
                Object key = e.getKey();
                Object value = e.getValue();
                if (!(value == null ? mo.get(key) != null || !mo.containsKey(key) : !value.equals(mo.get(key)))) continue;
                return false;
            }
            return true;
        }
        Map map = this.map;
        synchronized (map) {
            if (mo.size() != this.map.size()) {
                return false;
            }
            for (Map.Entry e : this.map.entrySet()) {
                Object key = e.getKey();
                Object value = e.getValue();
                if (value == null) {
                    if (mo.get(key) == null && mo.containsKey(key)) continue;
                    return false;
                }
                if (value.equals(mo.get(key))) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        if (this.fast) {
            int h = 0;
            Iterator i = this.map.entrySet().iterator();
            while (i.hasNext()) {
                h += ((Object)i.next()).hashCode();
            }
            return h;
        }
        Map map = this.map;
        synchronized (map) {
            int h = 0;
            Iterator i = this.map.entrySet().iterator();
            while (i.hasNext()) {
                h += ((Object)i.next()).hashCode();
            }
            return h;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object clone() {
        WeakFastHashMap results = null;
        if (this.fast) {
            results = new WeakFastHashMap(this.map);
        } else {
            Map map = this.map;
            synchronized (map) {
                results = new WeakFastHashMap(this.map);
            }
        }
        results.setFast(this.getFast());
        return results;
    }

    @Override
    public Set entrySet() {
        return new EntrySet();
    }

    @Override
    public Set keySet() {
        return new KeySet();
    }

    @Override
    public Collection values() {
        return new Values();
    }

    protected Map createMap() {
        return new WeakHashMap();
    }

    protected Map createMap(int capacity) {
        return new WeakHashMap(capacity);
    }

    protected Map createMap(int capacity, float factor) {
        return new WeakHashMap(capacity, factor);
    }

    protected Map createMap(Map map) {
        return new WeakHashMap(map);
    }

    protected Map cloneMap(Map map) {
        return this.createMap(map);
    }

    private class EntrySet
    extends CollectionView
    implements Set {
        private EntrySet() {
        }

        @Override
        protected Collection get(Map map) {
            return map.entrySet();
        }

        @Override
        protected Object iteratorNext(Map.Entry entry) {
            return entry;
        }
    }

    private class Values
    extends CollectionView {
        private Values() {
        }

        @Override
        protected Collection get(Map map) {
            return map.values();
        }

        @Override
        protected Object iteratorNext(Map.Entry entry) {
            return entry.getValue();
        }
    }

    private class KeySet
    extends CollectionView
    implements Set {
        private KeySet() {
        }

        @Override
        protected Collection get(Map map) {
            return map.keySet();
        }

        @Override
        protected Object iteratorNext(Map.Entry entry) {
            return entry.getKey();
        }
    }

    private abstract class CollectionView
    implements Collection {
        protected abstract Collection get(Map var1);

        protected abstract Object iteratorNext(Map.Entry var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            if (WeakFastHashMap.this.fast) {
                WeakFastHashMap weakFastHashMap = WeakFastHashMap.this;
                synchronized (weakFastHashMap) {
                    WeakFastHashMap.this.map = WeakFastHashMap.this.createMap();
                }
            }
            Map map = WeakFastHashMap.this.map;
            synchronized (map) {
                this.get(WeakFastHashMap.this.map).clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            if (WeakFastHashMap.this.fast) {
                WeakFastHashMap weakFastHashMap = WeakFastHashMap.this;
                synchronized (weakFastHashMap) {
                    Map temp = WeakFastHashMap.this.cloneMap(WeakFastHashMap.this.map);
                    boolean r = this.get(temp).remove(o);
                    WeakFastHashMap.this.map = temp;
                    return r;
                }
            }
            Map map = WeakFastHashMap.this.map;
            synchronized (map) {
                return this.get(WeakFastHashMap.this.map).remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection o) {
            if (WeakFastHashMap.this.fast) {
                WeakFastHashMap weakFastHashMap = WeakFastHashMap.this;
                synchronized (weakFastHashMap) {
                    Map temp = WeakFastHashMap.this.cloneMap(WeakFastHashMap.this.map);
                    boolean r = this.get(temp).removeAll(o);
                    WeakFastHashMap.this.map = temp;
                    return r;
                }
            }
            Map map = WeakFastHashMap.this.map;
            synchronized (map) {
                return this.get(WeakFastHashMap.this.map).removeAll(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection o) {
            if (WeakFastHashMap.this.fast) {
                WeakFastHashMap weakFastHashMap = WeakFastHashMap.this;
                synchronized (weakFastHashMap) {
                    Map temp = WeakFastHashMap.this.cloneMap(WeakFastHashMap.this.map);
                    boolean r = this.get(temp).retainAll(o);
                    WeakFastHashMap.this.map = temp;
                    return r;
                }
            }
            Map map = WeakFastHashMap.this.map;
            synchronized (map) {
                return this.get(WeakFastHashMap.this.map).retainAll(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            if (WeakFastHashMap.this.fast) {
                return this.get(WeakFastHashMap.this.map).size();
            }
            Map map = WeakFastHashMap.this.map;
            synchronized (map) {
                return this.get(WeakFastHashMap.this.map).size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            if (WeakFastHashMap.this.fast) {
                return this.get(WeakFastHashMap.this.map).isEmpty();
            }
            Map map = WeakFastHashMap.this.map;
            synchronized (map) {
                return this.get(WeakFastHashMap.this.map).isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            if (WeakFastHashMap.this.fast) {
                return this.get(WeakFastHashMap.this.map).contains(o);
            }
            Map map = WeakFastHashMap.this.map;
            synchronized (map) {
                return this.get(WeakFastHashMap.this.map).contains(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsAll(Collection o) {
            if (WeakFastHashMap.this.fast) {
                return this.get(WeakFastHashMap.this.map).containsAll(o);
            }
            Map map = WeakFastHashMap.this.map;
            synchronized (map) {
                return this.get(WeakFastHashMap.this.map).containsAll(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray(Object[] o) {
            if (WeakFastHashMap.this.fast) {
                return this.get(WeakFastHashMap.this.map).toArray(o);
            }
            Map map = WeakFastHashMap.this.map;
            synchronized (map) {
                return this.get(WeakFastHashMap.this.map).toArray(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            if (WeakFastHashMap.this.fast) {
                return this.get(WeakFastHashMap.this.map).toArray();
            }
            Map map = WeakFastHashMap.this.map;
            synchronized (map) {
                return this.get(WeakFastHashMap.this.map).toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (WeakFastHashMap.this.fast) {
                return this.get(WeakFastHashMap.this.map).equals(o);
            }
            Map map = WeakFastHashMap.this.map;
            synchronized (map) {
                return this.get(WeakFastHashMap.this.map).equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            if (WeakFastHashMap.this.fast) {
                return this.get(WeakFastHashMap.this.map).hashCode();
            }
            Map map = WeakFastHashMap.this.map;
            synchronized (map) {
                return this.get(WeakFastHashMap.this.map).hashCode();
            }
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator iterator() {
            return new CollectionViewIterator();
        }

        private class CollectionViewIterator
        implements Iterator {
            private Map expected;
            private Map.Entry lastReturned = null;
            private Iterator iterator;

            public CollectionViewIterator() {
                this.expected = WeakFastHashMap.this.map;
                this.iterator = this.expected.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.expected != WeakFastHashMap.this.map) {
                    throw new ConcurrentModificationException();
                }
                return this.iterator.hasNext();
            }

            public Object next() {
                if (this.expected != WeakFastHashMap.this.map) {
                    throw new ConcurrentModificationException();
                }
                this.lastReturned = (Map.Entry)this.iterator.next();
                return CollectionView.this.iteratorNext(this.lastReturned);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (WeakFastHashMap.this.fast) {
                    WeakFastHashMap weakFastHashMap = WeakFastHashMap.this;
                    synchronized (weakFastHashMap) {
                        if (this.expected != WeakFastHashMap.this.map) {
                            throw new ConcurrentModificationException();
                        }
                        WeakFastHashMap.this.remove(this.lastReturned.getKey());
                        this.lastReturned = null;
                        this.expected = WeakFastHashMap.this.map;
                    }
                } else {
                    this.iterator.remove();
                    this.lastReturned = null;
                }
            }
        }
    }
}

