/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.commons.collections.iterators;

import ar.apache.commons.collections.MapIterator;
import ar.apache.commons.collections.ResettableIterator;
import java.util.Iterator;
import java.util.Map;

public class EntrySetMapIterator
implements MapIterator,
ResettableIterator {
    private final Map map;
    private Iterator iterator;
    private Map.Entry last;
    private boolean canRemove = false;

    public EntrySetMapIterator(Map map) {
        this.map = map;
        this.iterator = map.entrySet().iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Object next() {
        this.last = (Map.Entry)this.iterator.next();
        this.canRemove = true;
        return this.last.getKey();
    }

    @Override
    public void remove() {
        if (!this.canRemove) {
            throw new IllegalStateException("Iterator remove() can only be called once after next()");
        }
        this.iterator.remove();
        this.last = null;
        this.canRemove = false;
    }

    @Override
    public Object getKey() {
        if (this.last == null) {
            throw new IllegalStateException("Iterator getKey() can only be called after next() and before remove()");
        }
        return this.last.getKey();
    }

    @Override
    public Object getValue() {
        if (this.last == null) {
            throw new IllegalStateException("Iterator getValue() can only be called after next() and before remove()");
        }
        return this.last.getValue();
    }

    @Override
    public Object setValue(Object value) {
        if (this.last == null) {
            throw new IllegalStateException("Iterator setValue() can only be called after next() and before remove()");
        }
        return this.last.setValue(value);
    }

    @Override
    public void reset() {
        this.iterator = this.map.entrySet().iterator();
        this.last = null;
        this.canRemove = false;
    }

    public String toString() {
        if (this.last != null) {
            return "MapIterator[" + this.getKey() + "=" + this.getValue() + "]";
        }
        return "MapIterator[]";
    }
}

