/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.commons.collections.iterators;

import ar.apache.commons.collections.ResettableIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LoopingIterator
implements ResettableIterator {
    private Collection collection;
    private Iterator iterator;

    public LoopingIterator(Collection coll) {
        if (coll == null) {
            throw new NullPointerException("The collection must not be null");
        }
        this.collection = coll;
        this.reset();
    }

    @Override
    public boolean hasNext() {
        return this.collection.size() > 0;
    }

    public Object next() {
        if (this.collection.size() == 0) {
            throw new NoSuchElementException("There are no elements for this iterator to loop on");
        }
        if (!this.iterator.hasNext()) {
            this.reset();
        }
        return this.iterator.next();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    @Override
    public void reset() {
        this.iterator = this.collection.iterator();
    }

    public int size() {
        return this.collection.size();
    }
}

