/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.http.client.protocol;

import ar.apache.http.HttpEntity;
import ar.apache.http.HttpEntityEnclosingRequest;
import ar.apache.http.HttpException;
import ar.apache.http.HttpRequest;
import ar.apache.http.HttpRequestInterceptor;
import ar.apache.http.HttpVersion;
import ar.apache.http.ProtocolVersion;
import ar.apache.http.annotation.Immutable;
import ar.apache.http.client.config.RequestConfig;
import ar.apache.http.client.protocol.HttpClientContext;
import ar.apache.http.protocol.HttpContext;
import ar.apache.http.util.Args;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

