/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.http.impl;

import ar.apache.http.HttpResponse;
import ar.apache.http.HttpResponseFactory;
import ar.apache.http.ProtocolVersion;
import ar.apache.http.ReasonPhraseCatalog;
import ar.apache.http.StatusLine;
import ar.apache.http.annotation.Immutable;
import ar.apache.http.impl.EnglishReasonPhraseCatalog;
import ar.apache.http.message.BasicHttpResponse;
import ar.apache.http.message.BasicStatusLine;
import ar.apache.http.protocol.HttpContext;
import ar.apache.http.util.Args;
import java.util.Locale;

@Immutable
public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    public static final DefaultHttpResponseFactory INSTANCE = new DefaultHttpResponseFactory();
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        this.reasonCatalog = Args.notNull(catalog, "Reason phrase catalog");
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    @Override
    public HttpResponse newHttpResponse(ProtocolVersion ver, int status, HttpContext context) {
        Args.notNull(ver, "HTTP version");
        Locale loc = this.determineLocale(context);
        String reason = this.reasonCatalog.getReason(status, loc);
        BasicStatusLine statusline = new BasicStatusLine(ver, status, reason);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    @Override
    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context) {
        Args.notNull(statusline, "Status line");
        return new BasicHttpResponse(statusline, this.reasonCatalog, this.determineLocale(context));
    }

    protected Locale determineLocale(HttpContext context) {
        return Locale.getDefault();
    }
}

