/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.http.impl.client;

import ar.apache.http.HttpEntity;
import ar.apache.http.HttpResponse;
import ar.apache.http.StatusLine;
import ar.apache.http.annotation.Immutable;
import ar.apache.http.client.HttpResponseException;
import ar.apache.http.client.ResponseHandler;
import ar.apache.http.util.EntityUtils;
import java.io.IOException;

@Immutable
public abstract class AbstractResponseHandler<T>
implements ResponseHandler<T> {
    @Override
    public T handleResponse(HttpResponse response) throws HttpResponseException, IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            EntityUtils.consume(entity);
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        return entity == null ? null : (T)this.handleEntity(entity);
    }

    public abstract T handleEntity(HttpEntity var1) throws IOException;
}

