/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.http.impl.conn;

import ar.apache.commons.logging.Log;
import ar.apache.commons.logging.LogFactory;
import ar.apache.http.HttpHost;
import ar.apache.http.annotation.Immutable;
import ar.apache.http.client.protocol.HttpClientContext;
import ar.apache.http.config.Lookup;
import ar.apache.http.config.SocketConfig;
import ar.apache.http.conn.ConnectTimeoutException;
import ar.apache.http.conn.DnsResolver;
import ar.apache.http.conn.HttpClientConnectionOperator;
import ar.apache.http.conn.HttpHostConnectException;
import ar.apache.http.conn.ManagedHttpClientConnection;
import ar.apache.http.conn.SchemePortResolver;
import ar.apache.http.conn.UnsupportedSchemeException;
import ar.apache.http.conn.socket.ConnectionSocketFactory;
import ar.apache.http.conn.socket.LayeredConnectionSocketFactory;
import ar.apache.http.impl.conn.DefaultSchemePortResolver;
import ar.apache.http.impl.conn.SystemDefaultDnsResolver;
import ar.apache.http.protocol.HttpContext;
import ar.apache.http.util.Args;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketTimeoutException;

@Immutable
public class DefaultHttpClientConnectionOperator
implements HttpClientConnectionOperator {
    static final String SOCKET_FACTORY_REGISTRY = "http.socket-factory-registry";
    private final Log log = LogFactory.getLog(this.getClass());
    private final Lookup<ConnectionSocketFactory> socketFactoryRegistry;
    private final SchemePortResolver schemePortResolver;
    private final DnsResolver dnsResolver;

    public DefaultHttpClientConnectionOperator(Lookup<ConnectionSocketFactory> socketFactoryRegistry, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
        Args.notNull(socketFactoryRegistry, "Socket factory registry");
        this.socketFactoryRegistry = socketFactoryRegistry;
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
        this.dnsResolver = dnsResolver != null ? dnsResolver : SystemDefaultDnsResolver.INSTANCE;
    }

    private Lookup<ConnectionSocketFactory> getSocketFactoryRegistry(HttpContext context) {
        Lookup<ConnectionSocketFactory> reg = (Lookup<ConnectionSocketFactory>)context.getAttribute(SOCKET_FACTORY_REGISTRY);
        if (reg == null) {
            reg = this.socketFactoryRegistry;
        }
        return reg;
    }

    @Override
    public void connect(ManagedHttpClientConnection conn, HttpHost host, InetSocketAddress localAddress, int connectTimeout, SocketConfig socketConfig, HttpContext context) throws IOException {
        InetAddress[] inetAddressArray;
        Lookup<ConnectionSocketFactory> registry = this.getSocketFactoryRegistry(context);
        ConnectionSocketFactory sf = registry.lookup(host.getSchemeName());
        if (sf == null) {
            throw new UnsupportedSchemeException(host.getSchemeName() + " protocol is not supported");
        }
        if (host.getAddress() != null) {
            InetAddress[] inetAddressArray2 = new InetAddress[1];
            inetAddressArray = inetAddressArray2;
            inetAddressArray2[0] = host.getAddress();
        } else {
            inetAddressArray = this.dnsResolver.resolve(host.getHostName());
        }
        InetAddress[] addresses = inetAddressArray;
        int port = this.schemePortResolver.resolve(host);
        for (int i = 0; i < addresses.length; ++i) {
            InetSocketAddress remoteAddress;
            block16: {
                int linger;
                InetAddress address = addresses[i];
                boolean last = i == addresses.length - 1;
                Socket sock = sf.createSocket(context);
                sock.setSoTimeout(socketConfig.getSoTimeout());
                sock.setReuseAddress(socketConfig.isSoReuseAddress());
                sock.setTcpNoDelay(socketConfig.isTcpNoDelay());
                sock.setKeepAlive(socketConfig.isSoKeepAlive());
                if (socketConfig.getRcvBufSize() > 0) {
                    sock.setReceiveBufferSize(socketConfig.getRcvBufSize());
                }
                if (socketConfig.getSndBufSize() > 0) {
                    sock.setSendBufferSize(socketConfig.getSndBufSize());
                }
                if ((linger = socketConfig.getSoLinger()) >= 0) {
                    sock.setSoLinger(true, linger);
                }
                conn.bind(sock);
                remoteAddress = new InetSocketAddress(address, port);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Connecting to " + remoteAddress);
                }
                try {
                    sock = sf.connectSocket(connectTimeout, sock, host, remoteAddress, localAddress, context);
                    conn.bind(sock);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Connection established " + conn);
                    }
                    return;
                }
                catch (SocketTimeoutException ex) {
                    if (last) {
                        throw new ConnectTimeoutException(ex, host, addresses);
                    }
                }
                catch (ConnectException ex) {
                    if (last) {
                        String msg = ex.getMessage();
                        if ("Connection timed out".equals(msg)) {
                            throw new ConnectTimeoutException(ex, host, addresses);
                        }
                        throw new HttpHostConnectException(ex, host, addresses);
                    }
                }
                catch (NoRouteToHostException ex) {
                    if (!last) break block16;
                    throw ex;
                }
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("Connect to " + remoteAddress + " timed out. " + "Connection will be retried using another IP address");
        }
    }

    @Override
    public void upgrade(ManagedHttpClientConnection conn, HttpHost host, HttpContext context) {
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        Lookup<ConnectionSocketFactory> registry = this.getSocketFactoryRegistry(clientContext);
        ConnectionSocketFactory sf = registry.lookup(host.getSchemeName());
        if (sf == null) {
            throw new RuntimeException();
        }
        if (!(sf instanceof LayeredConnectionSocketFactory)) {
            throw new RuntimeException();
        }
        LayeredConnectionSocketFactory lsf = (LayeredConnectionSocketFactory)sf;
        Socket sock = conn.getSocket();
        try {
            int port = this.schemePortResolver.resolve(host);
            sock = lsf.createLayeredSocket(sock, host.getHostName(), port, context);
            conn.bind(sock);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

