/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.http.impl.cookie;

import ar.apache.http.annotation.Immutable;
import ar.apache.http.cookie.CommonCookieAttributeHandler;
import ar.apache.http.cookie.MalformedCookieException;
import ar.apache.http.cookie.SetCookie;
import ar.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import ar.apache.http.impl.cookie.DateParseException;
import ar.apache.http.impl.cookie.DateUtils;
import ar.apache.http.util.Args;
import java.util.Date;

@Immutable
public class BasicExpiresHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    private final String[] datepatterns;

    public BasicExpiresHandler(String[] datepatterns) {
        Args.notNull(datepatterns, "Array of date patterns");
        this.datepatterns = datepatterns;
    }

    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for 'expires' attribute");
        }
        Date expiry = null;
        try {
            expiry = DateUtils.parseDate(value, this.datepatterns);
        }
        catch (DateParseException e) {
            e.printStackTrace();
        }
        if (expiry == null) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + value);
        }
        cookie.setExpiryDate(expiry);
    }

    @Override
    public String getAttributeName() {
        return "expires";
    }
}

