/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.http.impl.execchain;

import ar.apache.http.Header;
import ar.apache.http.HttpEntity;
import ar.apache.http.HttpEntityEnclosingRequest;
import ar.apache.http.HttpRequest;
import ar.apache.http.annotation.NotThreadSafe;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@NotThreadSafe
class RequestEntityProxy
implements HttpEntity {
    private final HttpEntity original;
    private boolean consumed = false;

    static void enhance(HttpEntityEnclosingRequest request) {
        HttpEntity entity = request.getEntity();
        if (entity != null && !entity.isRepeatable() && !RequestEntityProxy.isEnhanced(entity)) {
            request.setEntity(new RequestEntityProxy(entity));
        }
    }

    static boolean isEnhanced(HttpEntity entity) {
        return entity instanceof RequestEntityProxy;
    }

    static boolean isRepeatable(HttpRequest request) {
        HttpEntity entity;
        if (request instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)request).getEntity()) != null) {
            RequestEntityProxy proxy;
            if (RequestEntityProxy.isEnhanced(entity) && !(proxy = (RequestEntityProxy)entity).isConsumed()) {
                return true;
            }
            return entity.isRepeatable();
        }
        return true;
    }

    RequestEntityProxy(HttpEntity original) {
        this.original = original;
    }

    public HttpEntity getOriginal() {
        return this.original;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    @Override
    public boolean isRepeatable() {
        return this.original.isRepeatable();
    }

    @Override
    public boolean isChunked() {
        return this.original.isChunked();
    }

    @Override
    public long getContentLength() {
        return this.original.getContentLength();
    }

    @Override
    public Header getContentType() {
        return this.original.getContentType();
    }

    @Override
    public Header getContentEncoding() {
        return this.original.getContentEncoding();
    }

    @Override
    public InputStream getContent() throws IllegalStateException {
        try {
            return this.original.getContent();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void writeTo(OutputStream outstream) {
        this.consumed = true;
        try {
            this.original.writeTo(outstream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isStreaming() {
        return this.original.isStreaming();
    }

    @Override
    @Deprecated
    public void consumeContent() {
        this.consumed = true;
        try {
            this.original.consumeContent();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RequestEntityProxy{");
        sb.append(this.original);
        sb.append('}');
        return sb.toString();
    }
}

