/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.http.impl.io;

import ar.apache.http.HttpException;
import ar.apache.http.HttpResponse;
import ar.apache.http.HttpResponseFactory;
import ar.apache.http.NoHttpResponseException;
import ar.apache.http.ParseException;
import ar.apache.http.StatusLine;
import ar.apache.http.annotation.NotThreadSafe;
import ar.apache.http.config.MessageConstraints;
import ar.apache.http.impl.DefaultHttpResponseFactory;
import ar.apache.http.impl.io.AbstractMessageParser;
import ar.apache.http.io.SessionInputBuffer;
import ar.apache.http.message.LineParser;
import ar.apache.http.message.ParserCursor;
import ar.apache.http.params.HttpParams;
import ar.apache.http.util.Args;
import ar.apache.http.util.CharArrayBuffer;
import java.io.IOException;

@NotThreadSafe
public class DefaultHttpResponseParser
extends AbstractMessageParser<HttpResponse> {
    private final HttpResponseFactory responseFactory;
    private final CharArrayBuffer lineBuf;

    @Deprecated
    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, HttpParams params) {
        super(buffer, lineParser, params);
        this.responseFactory = Args.notNull(responseFactory, "Response factory");
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, MessageConstraints constraints) {
        super(buffer, lineParser, constraints);
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer, MessageConstraints constraints) {
        this(buffer, null, null, constraints);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer) {
        this(buffer, null, null, MessageConstraints.DEFAULT);
    }

    @Override
    protected HttpResponse parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException, ParseException {
        this.lineBuf.clear();
        int i = sessionBuffer.readLine(this.lineBuf);
        if (i == -1) {
            throw new NoHttpResponseException("The target server failed to respond");
        }
        ParserCursor cursor = new ParserCursor(0, this.lineBuf.length());
        StatusLine statusline = this.lineParser.parseStatusLine(this.lineBuf, cursor);
        return this.responseFactory.newHttpResponse(statusline, null);
    }
}

