/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.http.protocol;

import ar.apache.http.HttpEntity;
import ar.apache.http.HttpEntityEnclosingRequest;
import ar.apache.http.HttpException;
import ar.apache.http.HttpRequest;
import ar.apache.http.HttpRequestInterceptor;
import ar.apache.http.HttpVersion;
import ar.apache.http.ProtocolVersion;
import ar.apache.http.annotation.Immutable;
import ar.apache.http.protocol.HttpContext;
import ar.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

