/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.log.output.jms;

import ar.apache.log.output.jms.AbstractJMSTarget;
import ar.apache.log.output.jms.MessageBuilder;
import ar.jms.Message;
import ar.jms.Session;
import ar.jms.Topic;
import ar.jms.TopicConnection;
import ar.jms.TopicConnectionFactory;
import ar.jms.TopicPublisher;
import ar.jms.TopicSession;

public class JMSTopicTarget
extends AbstractJMSTarget {
    private TopicConnectionFactory m_factory;
    private Topic m_topic;
    private TopicSession m_session;
    private TopicPublisher m_publisher;
    private TopicConnection m_connection;

    public JMSTopicTarget(MessageBuilder builder, TopicConnectionFactory factory, Topic topic) {
        super(builder);
        this.m_factory = factory;
        this.m_topic = topic;
        this.open();
    }

    @Override
    protected void send(Message message) {
        try {
            this.m_publisher.publish(message);
        }
        catch (Exception e) {
            this.getErrorHandler().error("Error publishing message", e, null);
        }
    }

    @Override
    protected Session getSession() {
        return this.m_session;
    }

    @Override
    protected synchronized void openConnection() {
        try {
            this.m_connection = this.m_factory.createTopicConnection();
            this.m_connection.start();
            this.m_session = this.m_connection.createTopicSession(false, 1);
            this.m_publisher = this.m_session.createPublisher(this.m_topic);
        }
        catch (Exception e) {
            this.getErrorHandler().error("Error starting connection", e, null);
        }
    }

    @Override
    protected synchronized void closeConnection() {
        try {
            if (null != this.m_publisher) {
                this.m_publisher.close();
            }
            if (null != this.m_session) {
                this.m_session.close();
            }
            if (null != this.m_connection) {
                this.m_connection.close();
            }
        }
        catch (Exception e) {
            this.getErrorHandler().error("Error closing connection", e, null);
        }
        this.m_publisher = null;
        this.m_session = null;
        this.m_connection = null;
    }
}

