/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.mercadopago.core;

import ar.apache.commons.lang.StringUtils;
import ar.apache.http.Header;
import ar.apache.http.message.BasicHeader;
import ar.com.sdd.mercadopago.MercadoPago;
import ar.com.sdd.mercadopago.core.MPApiResponse;
import ar.com.sdd.mercadopago.core.MPCache;
import ar.com.sdd.mercadopago.core.MPCoreUtils;
import ar.com.sdd.mercadopago.core.MPResourceArray;
import ar.com.sdd.mercadopago.core.MPValidator;
import ar.com.sdd.mercadopago.core.annotations.idempotent.Idempotent;
import ar.com.sdd.mercadopago.core.annotations.rest.DELETE;
import ar.com.sdd.mercadopago.core.annotations.rest.GET;
import ar.com.sdd.mercadopago.core.annotations.rest.POST;
import ar.com.sdd.mercadopago.core.annotations.rest.PUT;
import ar.com.sdd.mercadopago.core.annotations.rest.PayloadType;
import ar.com.sdd.mercadopago.exceptions.MPException;
import ar.com.sdd.mercadopago.net.HttpMethod;
import ar.com.sdd.mercadopago.net.MPRestClient;
import ar.google.common.collect.MapDifference;
import ar.google.common.collect.Maps;
import ar.google.gson.Gson;
import ar.google.gson.JsonArray;
import ar.google.gson.JsonElement;
import ar.google.gson.JsonObject;
import ar.google.gson.internal.LinkedTreeMap;
import ar.google.gson.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;

public abstract class MPBase {
    private static final transient List<String> ALLOWED_METHODS = Arrays.asList("findById", "save", "update", "delete");
    private static final transient List<String> ALLOWED_BULK_METHODS = Arrays.asList("all", "search");
    private static final transient List<String> METHODS_TO_VALIDATE = Arrays.asList("save", "update");
    public static final transient Boolean WITHOUT_CACHE = Boolean.FALSE;
    public static final transient Boolean WITH_CACHE = Boolean.TRUE;
    protected transient JsonObject _lastKnownJson = null;
    private transient String idempotenceKey = null;
    protected transient MPApiResponse lastApiResponse;

    public MPBase() {
        if (this.admitIdempotenceKey()) {
            this.idempotenceKey = UUID.randomUUID().toString();
        }
    }

    public String getIdempotenceKey() {
        return this.idempotenceKey;
    }

    public <T extends MPBase> T setIdempotenceKey(String idempotenceKey) throws MPException {
        if (!this.admitIdempotenceKey()) {
            throw new MPException(this.getClass().getSimpleName() + " does not admit an idempotence key");
        }
        this.idempotenceKey = idempotenceKey;
        return (T)this;
    }

    public MPApiResponse getLastApiResponse() {
        return this.lastApiResponse;
    }

    private boolean admitIdempotenceKey() {
        return this.getClass().getAnnotation(Idempotent.class) != null;
    }

    protected <T extends MPBase> T processMethod(String methodName, Boolean useCache) throws MPException {
        HashMap<String, String> mapParams = null;
        MPBase resource = MPBase.processMethod(this.getClass(), this, methodName, mapParams, useCache);
        MPBase.fillResource(resource, this);
        return (T)this;
    }

    protected static <T extends MPBase> T processMethod(Class clazz, String methodName, String param1, Boolean useCache) throws MPException {
        HashMap<String, String> mapParams = new HashMap<String, String>();
        mapParams.put("param1", param1);
        return MPBase.processMethod(clazz, null, methodName, mapParams, useCache);
    }

    protected static <T extends MPBase> T processMethod(Class clazz, String methodName, String param1, String param2, Boolean useCache) throws MPException {
        HashMap<String, String> mapParams = new HashMap<String, String>();
        mapParams.put("param1", param1);
        mapParams.put("param2", param2);
        return MPBase.processMethod(clazz, null, methodName, mapParams, useCache);
    }

    protected static <T extends MPBase> T processMethod(Class clazz, T resource, String methodName, HashMap<String, String> mapParams, Boolean useCache) throws MPException {
        MPApiResponse response;
        if (resource == null) {
            try {
                resource = (MPBase)clazz.newInstance();
            }
            catch (Exception ex) {
                throw new MPException(ex);
            }
        }
        if (!ALLOWED_METHODS.contains(methodName)) {
            throw new MPException("Method \"" + methodName + "\" not allowed");
        }
        AnnotatedElement annotatedMethod = MPBase.getAnnotatedMethod(clazz, methodName);
        HashMap<String, Object> hashAnnotation = MPBase.getRestInformation(annotatedMethod);
        HttpMethod httpMethod = (HttpMethod)((Object)hashAnnotation.get("method"));
        String path = MPBase.parsePath(hashAnnotation.get("path").toString(), mapParams, resource);
        int retries = Integer.valueOf(hashAnnotation.get("retries").toString());
        int connectionTimeout = Integer.valueOf(hashAnnotation.get("connectionTimeout").toString());
        int socketTimeout = Integer.valueOf(hashAnnotation.get("socketTimeout").toString());
        if (METHODS_TO_VALIDATE.contains(methodName)) {
            MPValidator.validate(resource);
        }
        PayloadType payloadType = (PayloadType)((Object)hashAnnotation.get("payloadType"));
        JsonObject payload = MPBase.generatePayload(httpMethod, resource);
        Collection<Header> colHeaders = MPBase.getStandardHeaders();
        if (StringUtils.isNotEmpty(((MPBase)resource).getIdempotenceKey())) {
            colHeaders.add(new BasicHeader("x-idempotency-key", ((MPBase)resource).getIdempotenceKey()));
        }
        if ((response = MPBase.callApi(httpMethod, path, payloadType, payload, colHeaders, retries, connectionTimeout, socketTimeout, useCache)).getStatusCode() >= 200 && response.getStatusCode() < 300) {
            resource = httpMethod != HttpMethod.DELETE ? MPBase.fillResourceWithResponseData(resource, response) : MPBase.cleanResource(resource);
        }
        ((MPBase)resource).lastApiResponse = response;
        return (T)resource;
    }

    protected static MPResourceArray processMethodBulk(Class clazz, String methodName, Boolean useCache) throws MPException {
        HashMap<String, String> mapParams = null;
        return MPBase.processMethodBulk(clazz, methodName, mapParams, useCache);
    }

    protected static MPResourceArray processMethodBulk(Class clazz, String methodName, String param1, Boolean useCache) throws MPException {
        HashMap<String, String> mapParams = new HashMap<String, String>();
        mapParams.put("param1", param1);
        return MPBase.processMethodBulk(clazz, methodName, mapParams, useCache);
    }

    protected static MPResourceArray processMethodBulk(Class clazz, String methodName, String param1, String param2, Boolean useCache) throws MPException {
        HashMap<String, String> mapParams = new HashMap<String, String>();
        mapParams.put("param1", param1);
        mapParams.put("param2", param2);
        return MPBase.processMethodBulk(clazz, methodName, mapParams, useCache);
    }

    protected static MPResourceArray processMethodBulk(Class clazz, String methodName, HashMap<String, String> mapParams, Boolean useCache) throws MPException {
        if (!ALLOWED_BULK_METHODS.contains(methodName)) {
            throw new MPException("Method \"" + methodName + "\" not allowed");
        }
        AnnotatedElement annotatedMethod = MPBase.getAnnotatedMethod(clazz, methodName);
        HashMap<String, Object> hashAnnotation = MPBase.getRestInformation(annotatedMethod);
        HttpMethod httpMethod = (HttpMethod)((Object)hashAnnotation.get("method"));
        String path = MPBase.parsePath(hashAnnotation.get("path").toString(), mapParams, null);
        int retries = Integer.valueOf(hashAnnotation.get("retries").toString());
        int connectionTimeout = Integer.valueOf(hashAnnotation.get("connectionTimeout").toString());
        int socketTimeout = Integer.valueOf(hashAnnotation.get("socketTimeout").toString());
        PayloadType payloadType = (PayloadType)((Object)hashAnnotation.get("payloadType"));
        Collection<Header> colHeaders = MPBase.getStandardHeaders();
        MPApiResponse response = MPBase.callApi(httpMethod, path, payloadType, null, colHeaders, retries, connectionTimeout, socketTimeout, useCache);
        MPResourceArray resourceArray = new MPResourceArray();
        if (response.getStatusCode() >= 200 && response.getStatusCode() < 300) {
            resourceArray._resourceArray = MPBase.fillArrayWithResponseData(clazz, response);
        }
        resourceArray.lastApiResponse = response;
        return resourceArray;
    }

    private static MPApiResponse callApi(HttpMethod httpMethod, String path, PayloadType payloadType, JsonObject payload, Collection<Header> colHeaders, int retries, int connectionTimeout, int socketTimeout, Boolean useCache) throws MPException {
        String cacheKey = httpMethod.toString() + "_" + path;
        MPApiResponse response = null;
        if (useCache.booleanValue()) {
            response = MPCache.getFromCache(cacheKey);
        }
        if (response == null) {
            response = new MPRestClient().executeRequest(httpMethod, path, payloadType, payload, colHeaders, retries, connectionTimeout, socketTimeout);
            if (useCache.booleanValue()) {
                MPCache.addToCache(cacheKey, response);
            } else {
                MPCache.removeFromCache(cacheKey);
            }
        }
        return response;
    }

    protected static <T extends MPBase> T fillResourceWithResponseData(T resource, MPApiResponse response) throws MPException {
        if (response.getJsonElementResponse() != null && response.getJsonElementResponse().isJsonObject()) {
            JsonObject jsonObject = (JsonObject)response.getJsonElementResponse();
            MPBase resourceObject = (MPBase)MPCoreUtils.getResourceFromJson(resource.getClass(), jsonObject);
            resource = MPBase.fillResource(resourceObject, resource);
            resource._lastKnownJson = MPCoreUtils.getJsonFromResource(resource);
        }
        return resource;
    }

    protected static <T extends MPBase> ArrayList<T> fillArrayWithResponseData(Class clazz, MPApiResponse response) throws MPException {
        JsonArray jsonArray;
        ArrayList<MPBase> resourceArray = new ArrayList<MPBase>();
        if (response.getJsonElementResponse() != null && (jsonArray = MPCoreUtils.getArrayFromJsonElement(response.getJsonElementResponse())) != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                MPBase resource = (MPBase)MPCoreUtils.getResourceFromJson(clazz, (JsonObject)jsonArray.get(i));
                resource._lastKnownJson = MPCoreUtils.getJsonFromResource(resource);
                resourceArray.add(resource);
            }
        }
        return resourceArray;
    }

    private static <T extends MPBase> T fillResource(T sourceResource, T destinationResource) throws MPException {
        Field[] declaredFields;
        for (Field field : declaredFields = destinationResource.getClass().getDeclaredFields()) {
            try {
                Field originField = sourceResource.getClass().getDeclaredField(field.getName());
                field.setAccessible(true);
                originField.setAccessible(true);
                field.set(destinationResource, originField.get(sourceResource));
            }
            catch (Exception ex) {
                throw new MPException(ex);
            }
        }
        return destinationResource;
    }

    private static <T extends MPBase> T cleanResource(T resource) throws MPException {
        Field[] declaredFields;
        for (Field field : declaredFields = resource.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                field.set(resource, null);
            }
            catch (Exception ex) {
                throw new MPException(ex);
            }
        }
        return resource;
    }

    private static Collection<Header> getStandardHeaders() {
        Vector<Header> colHeaders = new Vector<Header>();
        colHeaders.add(new BasicHeader("Content-Type", "application/json"));
        colHeaders.add(new BasicHeader("User-Agent", "MercadoPago Java SDK/1.0.10"));
        colHeaders.add(new BasicHeader("x-product-id", "BC32A7VTRPP001U8NHJ0"));
        return colHeaders;
    }

    private static <T extends MPBase> String parsePath(String path, HashMap<String, String> mapParams, T resource) throws MPException {
        StringBuilder processedPath = new StringBuilder();
        if (path.contains(":")) {
            int paramIterator = 0;
            while (path.contains(":")) {
                JsonObject json;
                ++paramIterator;
                processedPath.append(path, 0, path.indexOf(":"));
                String param = path = path.substring(path.indexOf(":") + 1);
                if (path.contains("/")) {
                    param = path.substring(0, path.indexOf("/"));
                }
                String value = null;
                if (paramIterator <= 2 && mapParams != null && StringUtils.isNotEmpty(mapParams.get("param" + String.valueOf(paramIterator)))) {
                    value = mapParams.get("param" + String.valueOf(paramIterator));
                } else if (mapParams != null && StringUtils.isNotEmpty(mapParams.get(param))) {
                    value = mapParams.get(param);
                } else if (resource != null && (json = MPCoreUtils.getJsonFromResource(resource)).get(param) != null) {
                    value = json.get(param).getAsString();
                }
                if (StringUtils.isEmpty(value)) {
                    throw new MPException("No argument supplied/found for method path");
                }
                processedPath.append(value);
                if (path.contains("/")) {
                    path = path.substring(path.indexOf("/"));
                    continue;
                }
                path = "";
            }
            if (StringUtils.isNotEmpty(path)) {
                processedPath.append(path);
            }
        } else {
            processedPath.append(path);
        }
        processedPath.insert(0, MercadoPago.SDK.getBaseUrl());
        String accessToken = StringUtils.isNotEmpty(MercadoPago.SDK.getUserToken()) ? MercadoPago.SDK.getUserToken() : MercadoPago.SDK.getAccessToken();
        String sep = "?";
        if (processedPath.toString().contains(sep)) {
            sep = "&";
        }
        processedPath.append(sep).append("access_token=").append(accessToken);
        if (!MPCoreUtils.validateUrl(processedPath.toString())) {
            throw new MPException("Processed URL not valid: " + processedPath.toString());
        }
        return processedPath.toString();
    }

    private static <T extends MPBase> JsonObject generatePayload(HttpMethod httpMethod, T resource) {
        JsonObject payload = null;
        if (httpMethod.equals((Object)HttpMethod.POST) || httpMethod.equals((Object)HttpMethod.PUT) && resource._lastKnownJson == null) {
            payload = MPCoreUtils.getJsonFromResource(resource);
        } else if (httpMethod.equals((Object)HttpMethod.PUT)) {
            JsonObject actualJson = MPCoreUtils.getJsonFromResource(resource);
            Type mapType = new TypeToken<Map<String, Object>>(){}.getType();
            Gson gson = new Gson();
            Map oldMap = (Map)gson.fromJson((JsonElement)resource._lastKnownJson, mapType);
            Map newMap = (Map)gson.fromJson((JsonElement)actualJson, mapType);
            MapDifference mapDifferences = Maps.difference(oldMap, newMap);
            payload = new JsonObject();
            for (Map.Entry entry : mapDifferences.entriesDiffering().entrySet()) {
                if (entry.getValue().rightValue() instanceof LinkedTreeMap) {
                    JsonObject jsonObject = gson.toJsonTree(entry.getValue().rightValue()).getAsJsonObject();
                    payload.add((String)entry.getKey(), jsonObject);
                    continue;
                }
                if (entry.getValue().rightValue() instanceof Boolean) {
                    payload.addProperty((String)entry.getKey(), (Boolean)entry.getValue().rightValue());
                    continue;
                }
                if (entry.getValue().rightValue() instanceof Number) {
                    payload.addProperty((String)entry.getKey(), (Number)entry.getValue().rightValue());
                    continue;
                }
                payload.addProperty((String)entry.getKey(), entry.getValue().rightValue().toString());
            }
            for (Map.Entry entry : mapDifferences.entriesOnlyOnRight().entrySet()) {
                if (entry.getValue() instanceof Boolean) {
                    payload.addProperty((String)entry.getKey(), (Boolean)((Object)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof Number) {
                    payload.addProperty((String)entry.getKey(), (Number)((Object)entry.getValue()));
                    continue;
                }
                payload.addProperty((String)entry.getKey(), entry.getValue().toString());
            }
        }
        return payload;
    }

    private static HashMap<String, Object> getRestInformation(AnnotatedElement element) throws MPException {
        if (element.getAnnotations().length == 0) {
            throw new MPException("No rest method found");
        }
        HashMap<String, Object> hashAnnotation = new HashMap<String, Object>();
        for (Annotation annotation : element.getAnnotations()) {
            if (annotation instanceof DELETE) {
                DELETE delete = (DELETE)annotation;
                if (StringUtils.isEmpty(delete.path())) {
                    throw new MPException("Path not found for DELETE method");
                }
                hashAnnotation = MPBase.fillHashAnnotations(hashAnnotation, HttpMethod.DELETE, delete.path(), null, delete.retries(), delete.connectionTimeout(), delete.socketTimeout());
                continue;
            }
            if (annotation instanceof GET) {
                GET get = (GET)annotation;
                if (StringUtils.isEmpty(get.path())) {
                    throw new MPException("Path not found for GET method");
                }
                hashAnnotation = MPBase.fillHashAnnotations(hashAnnotation, HttpMethod.GET, get.path(), null, get.retries(), get.connectionTimeout(), get.socketTimeout());
                continue;
            }
            if (annotation instanceof POST) {
                POST post = (POST)annotation;
                if (StringUtils.isEmpty(post.path())) {
                    throw new MPException("Path not found for POST method");
                }
                hashAnnotation = MPBase.fillHashAnnotations(hashAnnotation, HttpMethod.POST, post.path(), post.payloadType(), post.retries(), post.connectionTimeout(), post.socketTimeout());
                continue;
            }
            if (!(annotation instanceof PUT)) continue;
            PUT put = (PUT)annotation;
            if (StringUtils.isEmpty(put.path())) {
                throw new MPException("Path not found for PUT method");
            }
            hashAnnotation = MPBase.fillHashAnnotations(hashAnnotation, HttpMethod.PUT, put.path(), put.payloadType(), put.retries(), put.connectionTimeout(), put.socketTimeout());
        }
        return hashAnnotation;
    }

    private static HashMap<String, Object> fillHashAnnotations(HashMap<String, Object> hashAnnotation, HttpMethod method, String path, PayloadType payloadType, int retries, int connectionTimeout, int socketTimeout) throws MPException {
        if (hashAnnotation.containsKey("method")) {
            throw new MPException("Multiple rest methods found");
        }
        hashAnnotation.put("method", (Object)method);
        hashAnnotation.put("path", path);
        hashAnnotation.put("payloadType", (Object)payloadType);
        hashAnnotation.put("retries", retries);
        hashAnnotation.put("connectionTimeout", connectionTimeout);
        hashAnnotation.put("socketTimeout", socketTimeout);
        return hashAnnotation;
    }

    private static AnnotatedElement getAnnotatedMethod(Class clazz, String methodName) throws MPException {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName) || method.getDeclaredAnnotations().length <= 0) continue;
            return method;
        }
        throw new MPException("No annotated method found");
    }
}

