/*
 * Decompiled with CFR 0.152.
 */
package ar.google.common.collect;

import ar.annotation.Nullable;
import ar.google.common.annotations.GwtCompatible;
import ar.google.common.annotations.GwtIncompatible;
import ar.google.common.collect.ImmutableCollection;
import ar.google.common.collect.ImmutableMap;
import ar.google.common.collect.ImmutableSet;
import ar.google.common.collect.UnmodifiableIterator;
import ar.google.j2objc.annotations.Weak;
import java.io.Serializable;
import java.util.Map;

@GwtCompatible(emulated=true)
final class ImmutableMapKeySet<K, V>
extends ImmutableSet.Indexed<K> {
    @Weak
    private final ImmutableMap<K, V> map;

    ImmutableMapKeySet(ImmutableMap<K, V> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public UnmodifiableIterator<K> iterator() {
        return this.map.keyIterator();
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.map.containsKey(object);
    }

    @Override
    K get(int index) {
        return ((Map.Entry)((ImmutableCollection)((Object)this.map.entrySet())).asList().get(index)).getKey();
    }

    @Override
    boolean isPartialView() {
        return true;
    }

    @Override
    @GwtIncompatible(value="serialization")
    Object writeReplace() {
        return new KeySetSerializedForm<K>(this.map);
    }

    @GwtIncompatible(value="serialization")
    private static class KeySetSerializedForm<K>
    implements Serializable {
        final ImmutableMap<K, ?> map;
        private static final long serialVersionUID = 0L;

        KeySetSerializedForm(ImmutableMap<K, ?> map) {
            this.map = map;
        }

        Object readResolve() {
            return this.map.keySet();
        }
    }
}

