/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE file.
 */
package ar.apache.log.output.db;

import java.sql.DriverManager;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.sql.Connection;
import javax.sql.DataSource;

/**
 * A basic datasource that doesn't do any pooling but just wraps 
 * around default mechanisms.
 *
 * @author <a href="mailto:peter@apache.org">Peter Donald</a>
 */
public class DefaultDataSource {
    private final String   m_username;
    private final String   m_password;
    private final String   m_url;

    private PrintWriter    m_logWriter;
    private int            m_loginTimeout;

    public DefaultDataSource( final String url, 
                              final String username, 
                              final String password )
    {
        m_url = url;
        m_username = username;
        m_password = password;

        m_logWriter = new PrintWriter( System.err, true );
    }

}
