package ar.com.sdd.mercadopago;

import ar.com.sdd.mercadopago.core.MPCredentials;
import ar.com.sdd.mercadopago.core.annotations.rest.PayloadType;
import ar.com.sdd.mercadopago.exceptions.MPConfException;
import ar.com.sdd.mercadopago.exceptions.MPException;
import ar.apache.commons.lang3.StringUtils;
import ar.com.sdd.mercadopago.exceptions.MPRestException;
import ar.com.sdd.mercadopago.net.HttpMethod;
import ar.com.sdd.mercadopago.net.MPRestClient;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;

public class MercadoPagoConnector {

    public static class SDK {

        private static final String DEFAULT_BASE_URL = "https://api.mercadopago.com";

        private static String clientSecret = null;
        private static String clientId = null;
        private static String accessToken = null;
        private static String userToken = null;
        private static String appId = null;
        private static String baseUrl = DEFAULT_BASE_URL;

        /**
         * Configure Methods
         */
        public static void configure(String accessTokenValue) {

            accessToken = accessTokenValue;

            //Fix feo
            MercadoPago.SDK.configure(accessTokenValue);
        }

        public static void configure(String clientIdValue, String clientSecretValue) {
            clientId = clientIdValue;
            clientSecret = clientSecretValue;

            //Fix feo
            MercadoPago.SDK.configure(clientIdValue,clientSecretValue);
        }

        /**
         * Getter/Setter for ClientSecret
         */
        public static String getClientSecret() {
            return clientSecret;
        }

        public static void setClientSecret(String value) throws MPException {
            clientSecret = value;
            //Fix feo
            MercadoPago.SDK.setClientSecret(value);
            //
            //if (StringUtils.isNotEmpty(clientId)) {
            //    getAccessToken();
            //}


        }

        /**
         * Getter/Setter for ClientId
         */
        public static String getClientId() {
            return clientId;
        }

        public static void setClientId(String value) throws MPException {
            clientId = value;
            //Fix feo
            MercadoPago.SDK.setClientId(value);
            //
            //if (StringUtils.isNotEmpty(clientSecret)) {
            //    getAccessToken();
            //}

        }

        /**
         * Getter/Setter for AccessToken
         * The access token ir retrived when empty.
         */
        public static String getAccessToken() {
            try {
                accessToken = MercadoPago.SDK.getAccessToken();
            } catch (MPException e) {
                e.printStackTrace();
            }
            //
            //if (StringUtils.isNotEmpty(clientSecret)) {
            //    getAccessToken();
            //}

            //Fix Feo:
            // if (StringUtils.isEmpty(accessToken)) {
            //try {
            //        accessToken = MPCredentials.getAccessToken();
            //    } catch (MPException e) {
            //        e.printStackTrace();
            //    }
            // }
            return accessToken;
        }

        public static void setAccessToken(String value) {
            accessToken = value;
            //Fix feo
            try {
                MercadoPago.SDK.setAccessToken(value);
            } catch (MPConfException e) {
                e.printStackTrace();
            }

        }

        public static String getUserToken() {
            return userToken;
        }

        public static void setUserToken(String value) {
            userToken = value;
        }

        /**
         * Getter/Setter for AppId
         */
        public static String getAppId() {
            return appId;
        }

        public static void setAppId(String value) throws MPException {
            if (StringUtils.isNotEmpty(appId)) {
                throw new MPException("appId setting can not be changed");
            }
            appId = value;

            //Fix feo
            MercadoPago.SDK.setAppId(value);

        }

        /**
         * Getter/Setter for BaseUrl
         * (FOR TESTING ONLY)
         */
        public static String getBaseUrl() {
            return baseUrl;
        }

        public static void setBaseUrl(String value) {
            baseUrl = value;
            //Fix feo
            MercadoPago.SDK.setBaseUrl(value);


        }

        /**
         * Set configuration params with a hashmap.
         * Valid keys are: clientSecret, clientId, accessToken, appId
         *
         * @param hashConfigurationParams a String, String hashmap with the configuration params
         *                                throws MPConfException
         */
        public static void setConfiguration(HashMap<String, String> hashConfigurationParams) throws MPException {
            if (hashConfigurationParams == null) {
                throw new IllegalArgumentException("Invalid hashConfigurationParams parameter");
            }

            setClientSecret(getValueFromHashMap(hashConfigurationParams, "clientSecret"));
            setClientId(getValueFromHashMap(hashConfigurationParams, "clientId"));
            setAccessToken(getValueFromHashMap(hashConfigurationParams, "accessToken"));
            setAppId(getValueFromHashMap(hashConfigurationParams, "appId"));


            //Fix feo
            MercadoPago.SDK.setConfiguration(hashConfigurationParams);

        }

        /**
         * Extract a value from a HashMap if is not null or empty
         *
         * @param hashMap a String, String hashmap with the configuration params.
         * @param key     value key
         * @return the configuration param or null if the key does not exists or value is empty
         */
        private static String getValueFromHashMap(HashMap<String, String> hashMap, String key) {
            if (hashMap.containsKey(key) &&
                    StringUtils.isNotEmpty(hashMap.get(key))) {
                return hashMap.get(key);
            }
            return null;
        }

        /**
         * Set configuration params from a properties file
         *
         * @param filePath string with the path of the properties file
         * @throws MPConfException
         */
        public static void setConfiguration(String filePath) throws MPConfException {
            if (StringUtils.isEmpty(filePath)) {
                throw new IllegalArgumentException("File path can not be empty");
            }

            InputStream inputStream = null;
            try {
                Properties properties = new Properties();
                inputStream = SDK.class.getClassLoader().getResourceAsStream(filePath);
                if (inputStream == null) {
                    throw new IllegalArgumentException("File not found");
                }
                properties.load(inputStream);

                setConfiguration(properties);

            } catch (IllegalArgumentException iaException) {
                throw iaException;
            } catch (Exception exception) {
                throw new MPConfException(exception);
            } finally {
                try {
                    if (inputStream != null)
                        inputStream.close();
                } catch (Exception ex) {
                    // Do nothing
                }
            }

            //Fix feo
            MercadoPago.SDK.setConfiguration(filePath);


        }

        /**
         * Set configuration params from a properties obj
         *
         * @param properties Properties obj
         *                   throws MPConfException
         */
        public static void setConfiguration(Properties properties) throws MPException {

            setAppId(getValueFromProperties(properties, "appId"));

            if (StringUtils.isNotEmpty(getValueFromProperties(properties, "accessToken"))) {
                setAccessToken(getValueFromProperties(properties, "accessToken"));
            }

            if (StringUtils.isNotEmpty(getValueFromProperties(properties, "clientSecret"))) {
                setClientSecret(getValueFromProperties(properties, "clientSecret"));
                setClientId(getValueFromProperties(properties, "clientId"));
            }

            //Fix feo
            MercadoPago.SDK.setConfiguration(properties);

        }

        /**
         * Extract a value from a Properties object if is not null or empty
         *
         * @param properties Properties object
         * @param key        value key
         * @return the configuration param or null if the key does not exists or value is empty
         */
        private static String getValueFromProperties(Properties properties, String key) {
            if (properties.containsKey(key) &&
                    StringUtils.isNotEmpty(properties.getProperty(key))) {
                return properties.getProperty(key);
            }
            return null;
        }

        /**
         * Clean all the configuration variables
         * (FOR TESTING ONLY)
         */
        public static void cleanConfiguration() {
            clientSecret = null;
            clientId = null;
            accessToken = null;
            appId = null;
            baseUrl = DEFAULT_BASE_URL;
        }

    }

}
