package ar.com.sdd.mercadopago.core.annotations.rest;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Mercado Pago SDK
 * Rest Information annotation interface for POST
 * connection and socket timeouts are expressed in milliseconds
 *
 * Created by Eduardo Paoletta on 11/4/16.
 */
@Inherited
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface POST {
    String path();
    PayloadType payloadType() default PayloadType.JSON;

    int retries() default 0;
    int connectionTimeout() default 0;
    int socketTimeout() default 0;
}
