package ar.com.sdd.mercadopago.resources;

import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;


public class OAuth2Credential implements Serializable {

    private String clientId = null;
    private String clientSecret = null;
    private String grantType = "client_credentials";

    public OAuth2Credential() {

    }

    /**
     * Identificador del cliente (login name)
     **/


    @JsonProperty("client_id")
    @NotNull
    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    /**
     * Clave del cliente (login password)
     **/


    @JsonProperty("client_secret")
    @NotNull
    public String getClientSecret() {
        return clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    /**
     * Tipo de acceso (siempre client_credentials)
     **/


    @JsonProperty("grant_type")
    @NotNull
    public String getGrantType() {
        return grantType;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    @Override
    public String toString() {
        return "OAuth2Credential ["
                + ((clientId != null) ? "clientId=" + clientId + ", " : "")
                + ((clientSecret != null) ? "clientSecret=" + clientSecret + ", " : "")
                + ((grantType != null) ? "grantType=" + grantType : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        OAuth2Credential that = (OAuth2Credential) o;

        if (clientId != null ? !clientId.equals(that.clientId) : that.clientId != null) return false;
        if (clientSecret != null ? !clientSecret.equals(that.clientSecret) : that.clientSecret != null) return false;
        return grantType != null ? grantType.equals(that.grantType) : that.grantType == null;
    }

    @Override
    public int hashCode() {
        int result = clientId != null ? clientId.hashCode() : 0;
        result = 31 * result + (clientSecret != null ? clientSecret.hashCode() : 0);
        result = 31 * result + (grantType != null ? grantType.hashCode() : 0);
        return result;
    }
}

