/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at
 * http://www.opensource.org/licenses/cddl1.php
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

/*
 * DefaultValue.java
 *
 * Created on November 16, 2006, 2:04 PM
 *
 */

package ar.ws.rs;

import ar.ws.rs.CookieParam;
import ar.ws.rs.FormParam;
import ar.ws.rs.HeaderParam;
import ar.ws.rs.MatrixParam;
import ar.ws.rs.PathParam;
import ar.ws.rs.QueryParam;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Defines the default value of request metadata that is bound using one of the 
 * following annotations:
 * {@link ar.ws.rs.PathParam},
 * {@link ar.ws.rs.QueryParam},
 * {@link ar.ws.rs.MatrixParam},
 * {@link ar.ws.rs.CookieParam},
 * {@link ar.ws.rs.FormParam},
 * or {@link ar.ws.rs.HeaderParam}.
 * The default value is used if the corresponding metadata is not present in the
 * request.
 * 
 * <p>If the type of the annotated parameter is 
 * <code>List</code>, <code>Set</code> or <code>SortedSet</code> then the
 * resulting collection will have a single entry mapped from the supplied 
 * default value.</p>
 * 
 * <p>If this annotation is not used and the corresponding metadata is not
 * present in the request, the value will be an empty collection for 
 * <code>List</code>, <code>Set</code> or <code>SortedSet</code>, null for 
 * other object types, and the Java-defined default for primitive types.</p>
 * 
 * @see PathParam
 * @see QueryParam
 * @see FormParam
 * @see HeaderParam
 * @see MatrixParam
 * @see CookieParam
 */
@Target({ElementType.PARAMETER, ElementType.METHOD, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
public @interface DefaultValue {
    /**
     * The default value.
     */
    String value();
}
