/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at
 * http://www.opensource.org/licenses/cddl1.php
 * See the License for the specific language governing
 * permissions and limitations under the License.
 */

/*
 * Provider.java
 *
 * Created on May 15, 2007, 11:59 AM
 *
 */

package ar.ws.rs.ext;

import ar.ws.rs.ext.ContextResolver;
import ar.ws.rs.ext.ExceptionMapper;
import ar.ws.rs.ext.MessageBodyReader;
import ar.ws.rs.ext.MessageBodyWriter;
import java.lang.annotation.*;

/**
 * Marks an implementation of an extension interface.
 * 
 * @see MessageBodyReader
 * @see MessageBodyWriter
 * @see ContextResolver
 * @see ExceptionMapper
 */
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Provider {
    
}
