/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.commons.beanutils.locale;

import ar.apache.commons.beanutils.ConversionException;
import ar.apache.commons.beanutils.locale.LocaleConverter;
import ar.apache.commons.logging.Log;
import ar.apache.commons.logging.LogFactory;
import java.text.ParseException;
import java.util.Locale;

public abstract class BaseLocaleConverter
implements LocaleConverter {
    private Log log = LogFactory.getLog(BaseLocaleConverter.class);
    private Object defaultValue = null;
    protected boolean useDefault = false;
    protected Locale locale = Locale.getDefault();
    protected String pattern = null;
    protected boolean locPattern = false;

    protected BaseLocaleConverter(Locale locale, String pattern) {
        this(null, locale, pattern, false, false);
    }

    protected BaseLocaleConverter(Locale locale, String pattern, boolean locPattern) {
        this(null, locale, pattern, false, locPattern);
    }

    protected BaseLocaleConverter(Object defaultValue, Locale locale, String pattern) {
        this(defaultValue, locale, pattern, false);
    }

    protected BaseLocaleConverter(Object defaultValue, Locale locale, String pattern, boolean locPattern) {
        this(defaultValue, locale, pattern, true, locPattern);
    }

    private BaseLocaleConverter(Object defaultValue, Locale locale, String pattern, boolean useDefault, boolean locPattern) {
        if (useDefault) {
            this.defaultValue = defaultValue;
            this.useDefault = true;
        }
        if (locale != null) {
            this.locale = locale;
        }
        this.pattern = pattern;
        this.locPattern = locPattern;
    }

    protected abstract Object parse(Object var1, String var2) throws ParseException;

    public Object convert(Object value) {
        return this.convert(value, null);
    }

    public Object convert(Object value, String pattern) {
        return this.convert(null, value, pattern);
    }

    @Override
    public Object convert(Class type2, Object value) {
        return this.convert(type2, value, null);
    }

    @Override
    public Object convert(Class type2, Object value, String pattern) {
        if (value == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            this.log.debug("Null value specified for conversion, returing null");
            return null;
        }
        try {
            if (pattern != null) {
                return this.parse(value, pattern);
            }
            return this.parse(value, this.pattern);
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            if (e instanceof ConversionException) {
                throw (ConversionException)e;
            }
            throw new ConversionException(e);
        }
    }
}

