/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.http.client.methods;

import ar.apache.http.Header;
import ar.apache.http.HttpEntity;
import ar.apache.http.HttpEntityEnclosingRequest;
import ar.apache.http.HttpHost;
import ar.apache.http.HttpRequest;
import ar.apache.http.ProtocolVersion;
import ar.apache.http.RequestLine;
import ar.apache.http.annotation.NotThreadSafe;
import ar.apache.http.client.methods.HttpUriRequest;
import ar.apache.http.message.AbstractHttpMessage;
import ar.apache.http.message.BasicRequestLine;
import ar.apache.http.params.HttpParams;
import ar.apache.http.util.Args;
import java.net.URI;

@NotThreadSafe
public class HttpRequestWrapper
extends AbstractHttpMessage
implements HttpUriRequest {
    private final HttpRequest original;
    private final HttpHost target;
    private final String method;
    private RequestLine requestLine;
    private ProtocolVersion version;
    private URI uri;

    private HttpRequestWrapper(HttpRequest request, HttpHost target) {
        this.original = Args.notNull(request, "HTTP request");
        this.target = target;
        this.version = this.original.getRequestLine().getProtocolVersion();
        this.method = this.original.getRequestLine().getMethod();
        this.uri = request instanceof HttpUriRequest ? ((HttpUriRequest)request).getURI() : null;
        this.setHeaders(request.getAllHeaders());
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.version != null ? this.version : this.original.getProtocolVersion();
    }

    public void setProtocolVersion(ProtocolVersion version) {
        this.version = version;
        this.requestLine = null;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    public void setURI(URI uri) {
        this.uri = uri;
        this.requestLine = null;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public void abort() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAborted() {
        return false;
    }

    @Override
    public RequestLine getRequestLine() {
        if (this.requestLine == null) {
            String requestUri = this.uri != null ? this.uri.toASCIIString() : this.original.getRequestLine().getUri();
            if (requestUri == null || requestUri.isEmpty()) {
                requestUri = "/";
            }
            this.requestLine = new BasicRequestLine(this.method, requestUri, this.getProtocolVersion());
        }
        return this.requestLine;
    }

    public HttpRequest getOriginal() {
        return this.original;
    }

    public HttpHost getTarget() {
        return this.target;
    }

    public String toString() {
        return this.getRequestLine() + " " + this.headergroup;
    }

    public static HttpRequestWrapper wrap(HttpRequest request) {
        return HttpRequestWrapper.wrap(request, null);
    }

    public static HttpRequestWrapper wrap(HttpRequest request, HttpHost target) {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest) {
            return new HttpEntityEnclosingRequestWrapper((HttpEntityEnclosingRequest)request, target);
        }
        return new HttpRequestWrapper(request, target);
    }

    @Override
    @Deprecated
    public HttpParams getParams() {
        if (this.params == null) {
            this.params = this.original.getParams().copy();
        }
        return this.params;
    }

    static class HttpEntityEnclosingRequestWrapper
    extends HttpRequestWrapper
    implements HttpEntityEnclosingRequest {
        private HttpEntity entity;

        HttpEntityEnclosingRequestWrapper(HttpEntityEnclosingRequest request, HttpHost target) {
            super(request, target);
            this.entity = request.getEntity();
        }

        @Override
        public HttpEntity getEntity() {
            return this.entity;
        }

        @Override
        public void setEntity(HttpEntity entity) {
            this.entity = entity;
        }

        @Override
        public boolean expectContinue() {
            Header expect = this.getFirstHeader("Expect");
            return expect != null && "100-continue".equalsIgnoreCase(expect.getValue());
        }
    }
}

