/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.http.client.protocol;

import ar.apache.http.Header;
import ar.apache.http.HttpException;
import ar.apache.http.HttpRequest;
import ar.apache.http.HttpRequestInterceptor;
import ar.apache.http.annotation.Immutable;
import ar.apache.http.protocol.HttpContext;
import ar.apache.http.util.Args;
import java.util.Collection;

@Immutable
public class RequestDefaultHeaders
implements HttpRequestInterceptor {
    private final Collection<? extends Header> defaultHeaders;

    public RequestDefaultHeaders(Collection<? extends Header> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    public RequestDefaultHeaders() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        Collection<? extends Header> defHeaders = (Collection<? extends Header>)request.getParams().getParameter("http.default-headers");
        if (defHeaders == null) {
            defHeaders = this.defaultHeaders;
        }
        if (defHeaders != null) {
            for (Header header : defHeaders) {
                request.addHeader(header);
            }
        }
    }
}

