/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.http.impl.entity;

import ar.apache.http.HttpException;
import ar.apache.http.HttpMessage;
import ar.apache.http.ProtocolException;
import ar.apache.http.annotation.Immutable;
import ar.apache.http.entity.ContentLengthStrategy;
import ar.apache.http.impl.entity.LaxContentLengthStrategy;

@Immutable
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    public static final DisallowIdentityContentLengthStrategy INSTANCE = new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0));
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        long result = this.contentLengthStrategy.determineLength(message);
        if (result == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result;
    }
}

