/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.log;

import ar.apache.log.ErrorHandler;
import ar.apache.log.LogEvent;
import ar.apache.log.LogTarget;
import ar.apache.log.Logger;
import ar.apache.log.Priority;
import ar.apache.log.format.PatternFormatter;
import ar.apache.log.output.io.StreamTarget;
import ar.apache.log.util.DefaultErrorHandler;

public class Hierarchy {
    private static final String FORMAT = "%7.7{priority} %5.5{time}   [%8.8{category}] (%{context}): %{message}\\n%{throwable}";
    private static final Hierarchy c_hierarchy = new Hierarchy();
    private ErrorHandler m_errorHandler = new DefaultErrorHandler();
    private Logger m_rootLogger = new Logger(new InnerErrorHandler(), "", null, null);

    public static Hierarchy getDefaultHierarchy() {
        return c_hierarchy;
    }

    public Hierarchy() {
        PatternFormatter formatter = new PatternFormatter(FORMAT);
        StreamTarget target = new StreamTarget(System.out, formatter);
        this.setDefaultLogTarget(target);
    }

    public void setDefaultLogTarget(LogTarget target) {
        if (null == target) {
            throw new IllegalArgumentException("Can not set DefaultLogTarget to null");
        }
        LogTarget[] targets = new LogTarget[]{target};
        this.getRootLogger().setLogTargets(targets);
    }

    public void setDefaultLogTargets(LogTarget[] targets) {
        if (null == targets || 0 == targets.length) {
            throw new IllegalArgumentException("Can not set DefaultLogTargets to null");
        }
        for (int i = 0; i < targets.length; ++i) {
            if (null != targets[i]) continue;
            throw new IllegalArgumentException("Can not set DefaultLogTarget element to null");
        }
        this.getRootLogger().setLogTargets(targets);
    }

    public void setDefaultPriority(Priority priority) {
        if (null == priority) {
            throw new IllegalArgumentException("Can not set default Hierarchy Priority to null");
        }
        this.getRootLogger().setPriority(priority);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (null == errorHandler) {
            throw new IllegalArgumentException("Can not set default Hierarchy ErrorHandler to null");
        }
        this.m_errorHandler = errorHandler;
    }

    public Logger getLoggerFor(String category) {
        return this.getRootLogger().getChildLogger(category);
    }

    public void log(String message, Throwable throwable) {
        this.m_errorHandler.error(message, throwable, null);
    }

    public void log(String message) {
        this.log(message, null);
    }

    protected final Logger getRootLogger() {
        return this.m_rootLogger;
    }

    private class InnerErrorHandler
    implements ErrorHandler {
        private InnerErrorHandler() {
        }

        @Override
        public void error(String message, Throwable throwable, LogEvent event) {
            Hierarchy.this.m_errorHandler.error(message, throwable, event);
        }
    }
}

