/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.log.output;

import ar.apache.log.ErrorAware;
import ar.apache.log.ErrorHandler;
import ar.apache.log.LogEvent;
import ar.apache.log.LogTarget;
import ar.apache.log.output.AbstractTarget;
import java.util.LinkedList;

public class AsyncLogTarget
extends AbstractTarget
implements Runnable {
    private final LinkedList m_list;
    private final int m_queueSize;
    private final LogTarget m_logTarget;

    public AsyncLogTarget(LogTarget logTarget) {
        this(logTarget, 15);
    }

    public AsyncLogTarget(LogTarget logTarget, int queueSize) {
        this.m_logTarget = logTarget;
        this.m_list = new LinkedList();
        this.m_queueSize = queueSize;
        this.open();
    }

    @Override
    public synchronized void setErrorHandler(ErrorHandler errorHandler) {
        super.setErrorHandler(errorHandler);
        if (this.m_logTarget instanceof ErrorAware) {
            ((ErrorAware)((Object)this.m_logTarget)).setErrorHandler(errorHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doProcessEvent(LogEvent event) {
        LinkedList linkedList = this.m_list;
        synchronized (linkedList) {
            int size = this.m_list.size();
            while (this.m_queueSize <= size) {
                try {
                    this.m_list.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.m_list.addFirst(event);
            if (size == 0) {
                this.m_list.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        boolean interupted = false;
        while (true) {
            LogEvent event = null;
            LinkedList linkedList = this.m_list;
            synchronized (linkedList) {
                while (null == event) {
                    int size = this.m_list.size();
                    if (size > 0) {
                        event = (LogEvent)this.m_list.removeLast();
                        if (size != this.m_queueSize) continue;
                        this.m_list.notify();
                        continue;
                    }
                    if (interupted || Thread.interrupted()) {
                        return;
                    }
                    try {
                        this.m_list.wait();
                    }
                    catch (InterruptedException ie) {
                        interupted = true;
                    }
                }
            }
            try {
                this.m_logTarget.processEvent(event);
                continue;
            }
            catch (Throwable throwable) {
                this.getErrorHandler().error("Unknown error writing event.", throwable, event);
                continue;
            }
            break;
        }
    }
}

