/*
 * Decompiled with CFR 0.152.
 */
package ar.apache.log.output.io;

import ar.apache.log.LogEvent;
import ar.apache.log.format.Formatter;
import ar.apache.log.output.io.FileTarget;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class SafeFileTarget
extends FileTarget {
    public SafeFileTarget(File file, boolean append, Formatter formatter) throws IOException {
        super(file, append, formatter);
        this.shutdownStream();
    }

    @Override
    public synchronized void processEvent(LogEvent event) {
        if (!this.isOpen()) {
            this.getErrorHandler().error("Writing event to closed stream.", null, event);
            return;
        }
        try {
            FileOutputStream outputStream = new FileOutputStream(this.getFile().getPath(), true);
            this.setOutputStream(outputStream);
        }
        catch (Throwable throwable) {
            this.getErrorHandler().error("Unable to open file to write log event.", throwable, event);
            return;
        }
        super.processEvent(event);
        this.shutdownStream();
    }
}

