/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.mercadopago;

import ar.apache.commons.lang3.StringUtils;
import ar.com.sdd.mercadopago.MercadoPago;
import ar.com.sdd.mercadopago.exceptions.MPConfException;
import ar.com.sdd.mercadopago.exceptions.MPException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;

public class MercadoPagoConnector {

    public static class SDK {
        private static final String DEFAULT_BASE_URL = "https://api.mercadopago.com";
        private static String clientSecret = null;
        private static String clientId = null;
        private static String accessToken = null;
        private static String userToken = null;
        private static String appId = null;
        private static String baseUrl = "https://api.mercadopago.com";

        public static void configure(String accessTokenValue) {
            accessToken = accessTokenValue;
            MercadoPago.SDK.configure(accessTokenValue);
        }

        public static void configure(String clientIdValue, String clientSecretValue) {
            clientId = clientIdValue;
            clientSecret = clientSecretValue;
            MercadoPago.SDK.configure(clientIdValue, clientSecretValue);
        }

        public static String getClientSecret() {
            return clientSecret;
        }

        public static void setClientSecret(String value) throws MPException {
            clientSecret = value;
            MercadoPago.SDK.setClientSecret(value);
        }

        public static String getClientId() {
            return clientId;
        }

        public static void setClientId(String value) throws MPException {
            clientId = value;
            MercadoPago.SDK.setClientId(value);
        }

        public static String getAccessToken() {
            try {
                accessToken = MercadoPago.SDK.getAccessToken();
            }
            catch (MPException e) {
                e.printStackTrace();
            }
            return accessToken;
        }

        public static void setAccessToken(String value) {
            accessToken = value;
            try {
                MercadoPago.SDK.setAccessToken(value);
            }
            catch (MPConfException e) {
                e.printStackTrace();
            }
        }

        public static String getUserToken() {
            return userToken;
        }

        public static void setUserToken(String value) {
            userToken = value;
        }

        public static String getAppId() {
            return appId;
        }

        public static void setAppId(String value) throws MPException {
            if (StringUtils.isNotEmpty(appId)) {
                throw new MPException("appId setting can not be changed");
            }
            appId = value;
            MercadoPago.SDK.setAppId(value);
        }

        public static String getBaseUrl() {
            return baseUrl;
        }

        public static void setBaseUrl(String value) {
            baseUrl = value;
            MercadoPago.SDK.setBaseUrl(value);
        }

        public static void setConfiguration(HashMap<String, String> hashConfigurationParams) throws MPException {
            if (hashConfigurationParams == null) {
                throw new IllegalArgumentException("Invalid hashConfigurationParams parameter");
            }
            SDK.setClientSecret(SDK.getValueFromHashMap(hashConfigurationParams, "clientSecret"));
            SDK.setClientId(SDK.getValueFromHashMap(hashConfigurationParams, "clientId"));
            SDK.setAccessToken(SDK.getValueFromHashMap(hashConfigurationParams, "accessToken"));
            SDK.setAppId(SDK.getValueFromHashMap(hashConfigurationParams, "appId"));
            MercadoPago.SDK.setConfiguration(hashConfigurationParams);
        }

        private static String getValueFromHashMap(HashMap<String, String> hashMap, String key) {
            if (hashMap.containsKey(key) && StringUtils.isNotEmpty(hashMap.get(key))) {
                return hashMap.get(key);
            }
            return null;
        }

        public static void setConfiguration(String filePath) throws MPConfException {
            if (StringUtils.isEmpty(filePath)) {
                throw new IllegalArgumentException("File path can not be empty");
            }
            InputStream inputStream = null;
            try {
                Properties properties = new Properties();
                inputStream = SDK.class.getClassLoader().getResourceAsStream(filePath);
                if (inputStream == null) {
                    throw new IllegalArgumentException("File not found");
                }
                properties.load(inputStream);
                SDK.setConfiguration(properties);
            }
            catch (IllegalArgumentException iaException) {
                throw iaException;
            }
            catch (Exception exception) {
                throw new MPConfException(exception);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
            MercadoPago.SDK.setConfiguration(filePath);
        }

        public static void setConfiguration(Properties properties) throws MPException {
            SDK.setAppId(SDK.getValueFromProperties(properties, "appId"));
            if (StringUtils.isNotEmpty(SDK.getValueFromProperties(properties, "accessToken"))) {
                SDK.setAccessToken(SDK.getValueFromProperties(properties, "accessToken"));
            }
            if (StringUtils.isNotEmpty(SDK.getValueFromProperties(properties, "clientSecret"))) {
                SDK.setClientSecret(SDK.getValueFromProperties(properties, "clientSecret"));
                SDK.setClientId(SDK.getValueFromProperties(properties, "clientId"));
            }
            MercadoPago.SDK.setConfiguration(properties);
        }

        private static String getValueFromProperties(Properties properties, String key) {
            if (properties.containsKey(key) && StringUtils.isNotEmpty(properties.getProperty(key))) {
                return properties.getProperty(key);
            }
            return null;
        }

        public static void cleanConfiguration() {
            clientSecret = null;
            clientId = null;
            accessToken = null;
            appId = null;
            baseUrl = DEFAULT_BASE_URL;
        }
    }
}

