/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.mercadopago.resources;

import ar.com.sdd.mercadopago.core.MPBase;
import ar.com.sdd.mercadopago.core.MPResourceArray;
import ar.com.sdd.mercadopago.core.annotations.rest.DELETE;
import ar.com.sdd.mercadopago.core.annotations.rest.GET;
import ar.com.sdd.mercadopago.core.annotations.rest.POST;
import ar.com.sdd.mercadopago.core.annotations.rest.PUT;
import ar.com.sdd.mercadopago.exceptions.MPException;
import ar.com.sdd.mercadopago.resources.datastructures.customer.card.Cardholder;
import ar.com.sdd.mercadopago.resources.datastructures.customer.card.Issuer;
import ar.com.sdd.mercadopago.resources.datastructures.customer.card.PaymentMethod;
import ar.com.sdd.mercadopago.resources.datastructures.customer.card.SecurityCode;
import java.util.Date;

public class Card
extends MPBase {
    private String token = null;
    private String id = null;
    private String customerId = null;
    private Integer expirationMonth = null;
    private Integer expirationYear = null;
    private String firstSixDigits = null;
    private String lastFourDigits = null;
    private PaymentMethod paymentMethod = null;
    private SecurityCode securityCode = null;
    private Issuer issuer = null;
    private Cardholder cardholder = null;
    private Date dateCreated = null;
    private Date dateLastUpdated = null;
    private String paymentMethodId = null;

    public Card setToken(String token) {
        this.token = token;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Card setId(String id) {
        this.id = id;
        return this;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public Card setCustomerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    public Integer getExpirationMonth() {
        return this.expirationMonth;
    }

    public Card setExpirationMonth(Integer expirationMonth) {
        this.expirationMonth = expirationMonth;
        return this;
    }

    public Integer getExpirationYear() {
        return this.expirationYear;
    }

    public Card setExpirationYear(Integer expirationYear) {
        this.expirationYear = expirationYear;
        return this;
    }

    public String getFirstSixDigits() {
        return this.firstSixDigits;
    }

    public Card setFirstSixDigits(String firstSixDigits) {
        this.firstSixDigits = firstSixDigits;
        return this;
    }

    public String getLastFourDigits() {
        return this.lastFourDigits;
    }

    public Card setLastFourDigits(String lastFourDigits) {
        this.lastFourDigits = lastFourDigits;
        return this;
    }

    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public Card setPaymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    public SecurityCode getSecurityCode() {
        return this.securityCode;
    }

    public Card setSecurityCode(SecurityCode securityCode) {
        this.securityCode = securityCode;
        return this;
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public Card setIssuer(Issuer issuer) {
        this.issuer = issuer;
        return this;
    }

    public Cardholder getCardholder() {
        return this.cardholder;
    }

    public Card setCardholder(Cardholder cardholder) {
        this.cardholder = cardholder;
        return this;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public Card setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public Date getDateLastUpdated() {
        return this.dateLastUpdated;
    }

    public Card setDateLastUpdated(Date dateLastUpdated) {
        this.dateLastUpdated = dateLastUpdated;
        return this;
    }

    public static MPResourceArray all(String customerId) throws MPException {
        return Card.all(customerId, WITHOUT_CACHE);
    }

    @GET(path="/v1/customers/:customer_id/cards")
    public static MPResourceArray all(String customerId, Boolean useCache) {
        try {
            return Card.processMethodBulk(Card.class, "all", customerId, useCache);
        }
        catch (MPException e) {
            return null;
        }
    }

    public static Card findById(String customerId, String id) throws MPException {
        return Card.findById(customerId, id, WITHOUT_CACHE);
    }

    @GET(path="/v1/customers/:customer_id/cards/:id")
    public static Card findById(String customerId, String id, Boolean useCache) {
        try {
            return (Card)Card.processMethod(Card.class, "findById", customerId, id, useCache);
        }
        catch (MPException e) {
            e.printStackTrace();
            return null;
        }
    }

    @POST(path="/v1/customers/:customer_id/cards/")
    public Card save() {
        try {
            return (Card)super.processMethod("save", WITHOUT_CACHE);
        }
        catch (MPException e) {
            e.printStackTrace();
            return null;
        }
    }

    @PUT(path="/v1/customers/:customer_id/cards/:id")
    public Card update() {
        try {
            return (Card)super.processMethod("update", WITHOUT_CACHE);
        }
        catch (MPException e) {
            e.printStackTrace();
            return null;
        }
    }

    @DELETE(path="/v1/customers/:customer_id/cards/:id")
    public Card delete() {
        try {
            return (Card)super.processMethod("delete", WITHOUT_CACHE);
        }
        catch (MPException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public void setPaymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }
}

