/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.mercadopago.resources;

import ar.com.sdd.mercadopago.core.MPBase;
import ar.com.sdd.mercadopago.core.annotations.idempotent.Idempotent;
import ar.com.sdd.mercadopago.core.annotations.rest.GET;
import ar.com.sdd.mercadopago.core.annotations.rest.POST;
import ar.com.sdd.mercadopago.core.annotations.rest.PUT;
import ar.com.sdd.mercadopago.core.annotations.validation.Numeric;
import ar.com.sdd.mercadopago.core.annotations.validation.Size;
import ar.com.sdd.mercadopago.exceptions.MPException;
import ar.com.sdd.mercadopago.resources.Card;
import ar.com.sdd.mercadopago.resources.datastructures.payment.AdditionalInfo;
import ar.com.sdd.mercadopago.resources.datastructures.payment.FeeDetail;
import ar.com.sdd.mercadopago.resources.datastructures.payment.Order;
import ar.com.sdd.mercadopago.resources.datastructures.payment.Payer;
import ar.com.sdd.mercadopago.resources.datastructures.payment.Refund;
import ar.com.sdd.mercadopago.resources.datastructures.payment.TransactionDetails;
import ar.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Date;

@Idempotent
public class Payment
extends MPBase {
    private String id = null;
    private Date dateCreated = null;
    private Date dateApproved = null;
    private Date dateLastUpdated = null;
    private Date moneyReleaseDate = null;
    private Integer collectorId = null;
    private String authorizationCode = null;
    private OperationType operationType = null;
    private Payer payer = null;
    private Boolean binaryMode = null;
    private Boolean liveMode = null;
    private Order order = null;
    private String externalReference = null;
    private String description = null;
    private JsonObject metadata = null;
    @Size(min=3, max=3)
    private CurrencyId currencyId = null;
    private Float transactionAmount = null;
    private Float transactionAmountRefunded = null;
    private Float couponAmount = null;
    private Integer campaignId = null;
    private String couponCode = null;
    private TransactionDetails transactionDetails = null;
    private ArrayList<FeeDetail> feeDetails = null;
    private Integer differentialPricingId = null;
    private Float applicationFee = null;
    private Status status = null;
    private String statusDetail = null;
    private Boolean capture = null;
    private Boolean captured = null;
    private String callForAuthorizeId = null;
    private String paymentMethodId = null;
    private String issuerId = null;
    private PaymentTypeId paymentTypeId = null;
    private String token = null;
    private Card card = null;
    private String statementDescriptor = null;
    @Numeric(min=1.0f, fractionDigits=0)
    private Integer installments = null;
    private String notificationUrl = null;
    private ArrayList<Refund> refunds = null;
    private AdditionalInfo additionalInfo = null;

    public String getId() {
        return this.id;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public Date getDateApproved() {
        return this.dateApproved;
    }

    public Date getDateLastUpdated() {
        return this.dateLastUpdated;
    }

    public Date getMoneyReleaseDate() {
        return this.moneyReleaseDate;
    }

    public Integer getCollectorId() {
        return this.collectorId;
    }

    public String getAuthorizationCode() {
        return this.authorizationCode;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public Payer getPayer() {
        return this.payer;
    }

    public Payment setPayer(Payer payer) {
        this.payer = payer;
        return this;
    }

    public Boolean getBinaryMode() {
        return this.binaryMode;
    }

    public Payment setBinaryMode(Boolean binaryMode) {
        this.binaryMode = binaryMode;
        return this;
    }

    public Boolean getLiveMode() {
        return this.liveMode;
    }

    public Order getOrder() {
        return this.order;
    }

    public Payment setOrder(Order order) {
        this.order = order;
        return this;
    }

    public String getExternalReference() {
        return this.externalReference;
    }

    public Payment setExternalReference(String externalReference) {
        this.externalReference = externalReference;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Payment setDescription(String description) {
        this.description = description;
        return this;
    }

    public JsonObject getMetadata() {
        return this.metadata;
    }

    public Payment setMetadata(JsonObject metadata) {
        this.metadata = metadata;
        return this;
    }

    public CurrencyId getCurrencyId() {
        return this.currencyId;
    }

    public Float getTransactionAmount() {
        return this.transactionAmount;
    }

    public Payment setTransactionAmount(Float transactionAmount) {
        this.transactionAmount = transactionAmount;
        return this;
    }

    public Float getTransactionAmountRefunded() {
        return this.transactionAmountRefunded;
    }

    public Float getCouponAmount() {
        return this.couponAmount;
    }

    public Payment setCouponAmount(Float couponAmount) {
        this.couponAmount = couponAmount;
        return this;
    }

    public Payment setCampaignId(Integer campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public Payment setCouponCode(String couponCode) {
        this.couponCode = couponCode;
        return this;
    }

    public TransactionDetails getTransactionDetails() {
        return this.transactionDetails;
    }

    public ArrayList<FeeDetail> getFeeDetails() {
        return this.feeDetails;
    }

    public Integer getDifferentialPricingId() {
        return this.differentialPricingId;
    }

    public Payment setDifferentialPricingId(Integer differentialPricingId) {
        this.differentialPricingId = differentialPricingId;
        return this;
    }

    public Payment setApplicationFee(Float applicationFee) {
        this.applicationFee = applicationFee;
        return this;
    }

    public Status getStatus() {
        return this.status;
    }

    public Payment setStatus(Status status) {
        this.status = status;
        return this;
    }

    public String getStatusDetail() {
        return this.statusDetail;
    }

    public Payment setCapture(Boolean capture) {
        this.capture = capture;
        return this;
    }

    public Boolean getCaptured() {
        return this.captured;
    }

    public String getCallForAuthorizeId() {
        return this.callForAuthorizeId;
    }

    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public Payment setPaymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
        return this;
    }

    public String getIssuerId() {
        return this.issuerId;
    }

    public Payment setIssuerId(String issuerId) {
        this.issuerId = issuerId;
        return this;
    }

    public PaymentTypeId getPaymentTypeId() {
        return this.paymentTypeId;
    }

    public Payment setToken(String token) {
        this.token = token;
        return this;
    }

    public Card getCard() {
        return this.card;
    }

    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    public Payment setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
        return this;
    }

    public Integer getInstallments() {
        return this.installments;
    }

    public Payment setInstallments(Integer installments) {
        this.installments = installments;
        return this;
    }

    public String getNotificationUrl() {
        return this.notificationUrl;
    }

    public Payment setNotificationUrl(String notificationUrl) {
        this.notificationUrl = notificationUrl;
        return this;
    }

    public ArrayList<Refund> getRefunds() {
        return this.refunds;
    }

    public Payment setAdditionalInfo(AdditionalInfo additionalInfo) {
        this.additionalInfo = additionalInfo;
        return this;
    }

    public static Payment findById(String id) throws MPException {
        return Payment.findById(id, WITHOUT_CACHE);
    }

    @GET(path="/v1/payments/:id")
    public static Payment findById(String id, Boolean useCache) {
        try {
            return (Payment)Payment.processMethod(Payment.class, "findById", id, useCache);
        }
        catch (MPException e) {
            e.printStackTrace();
            return null;
        }
    }

    @POST(path="/v1/payments")
    public Payment save() {
        try {
            return (Payment)super.processMethod("save", WITHOUT_CACHE);
        }
        catch (MPException e) {
            e.printStackTrace();
            return null;
        }
    }

    @PUT(path="/v1/payments/:id")
    public Payment update() {
        try {
            return (Payment)super.processMethod("update", WITHOUT_CACHE);
        }
        catch (MPException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static enum PaymentTypeId {
        account_money,
        ticket,
        bank_transfer,
        atm,
        credit_card,
        debit_card,
        prepaid_card;

    }

    public static enum Status {
        pending,
        approved,
        authorized,
        in_process,
        in_mediation,
        rejected,
        cancelled,
        refunded,
        charged_back;

    }

    public static enum CurrencyId {
        ARS,
        BRL,
        VEF,
        CLP,
        MXN,
        COP,
        PEN,
        UYU;

    }

    public static enum OperationType {
        regular_payment,
        money_transfer,
        recurring_payment,
        account_fund,
        payment_addition,
        cellphone_recharge,
        pos_payment;

    }
}

