/*
 * Decompiled with CFR 0.152.
 */
package ar.jms;

import ar.jms.InvalidDestinationException;
import ar.jms.JMSException;
import ar.jms.Message;
import ar.jms.TemporaryTopic;
import ar.jms.Topic;
import ar.jms.TopicPublisher;
import ar.jms.TopicSession;
import ar.jms.TopicSubscriber;

public class TopicRequestor {
    TopicSession session;
    TemporaryTopic tempTopic;
    TopicPublisher publisher;
    TopicSubscriber subscriber;

    public TopicRequestor(TopicSession session, Topic topic) throws JMSException {
        if (topic == null) {
            throw new InvalidDestinationException("topic==null");
        }
        this.session = session;
        this.tempTopic = session.createTemporaryTopic();
        this.publisher = session.createPublisher(topic);
        this.subscriber = session.createSubscriber(this.tempTopic);
    }

    public Message request(Message message) throws JMSException {
        message.setJMSReplyTo(this.tempTopic);
        this.publisher.publish(message);
        return this.subscriber.receive();
    }

    public void close() throws JMSException {
        this.session.close();
        this.tempTopic.delete();
    }
}

