/*
 * Decompiled with CFR 0.152.
 */
package ar.sun.jersey.core.osgi;

import ar.osgi.framework.Bundle;
import ar.osgi.framework.BundleContext;
import ar.osgi.framework.BundleEvent;
import ar.osgi.framework.BundleReference;
import ar.osgi.framework.FrameworkUtil;
import ar.osgi.framework.SynchronousBundleListener;
import ar.sun.jersey.core.reflection.ReflectionHelper;
import ar.sun.jersey.core.spi.scanning.PackageNamesScanner;
import ar.sun.jersey.impl.SpiMessages;
import ar.sun.jersey.spi.service.ServiceConfigurationError;
import ar.sun.jersey.spi.service.ServiceFinder;
import ar.ws.rs.ext.RuntimeDelegate;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class OsgiRegistry
implements SynchronousBundleListener {
    private static final String CoreBundleSymbolicNAME = "ar.sun.jersey.core";
    private static final Logger LOGGER = Logger.getLogger(OsgiRegistry.class.getName());
    private final BundleContext bundleContext;
    private final Map<Long, Map<String, Callable<List<Class<?>>>>> factories = new HashMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private static OsgiRegistry instance;
    private Map<String, Bundle> classToBundleMapping = new HashMap<String, Bundle>();

    public static synchronized OsgiRegistry getInstance() {
        BundleContext context;
        ClassLoader classLoader;
        if (instance == null && (classLoader = ReflectionHelper.class.getClassLoader()) instanceof BundleReference && (context = FrameworkUtil.getBundle(OsgiRegistry.class).getBundleContext()) != null) {
            instance = new OsgiRegistry(context);
            instance.hookUp();
        }
        return instance;
    }

    @Override
    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 32) {
            this.register(event.getBundle());
        } else if (event.getType() == 64 || event.getType() == 16) {
            Bundle unregisteredBundle = event.getBundle();
            this.lock.writeLock().lock();
            try {
                this.factories.remove(unregisteredBundle.getBundleId());
                if (unregisteredBundle.getSymbolicName().equals(CoreBundleSymbolicNAME)) {
                    this.bundleContext.removeBundleListener(this);
                    this.factories.clear();
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    private void setOSGiPackageScannerResourceProvider() {
        PackageNamesScanner.setResourcesProvider(new PackageNamesScanner.ResourcesProvider(){

            @Override
            public Enumeration<URL> getResources(String packagePath, ClassLoader classLoader) throws IOException {
                LinkedList<URL> result = new LinkedList<URL>();
                OsgiRegistry.this.classToBundleMapping.clear();
                for (Bundle bundle : OsgiRegistry.this.bundleContext.getBundles()) {
                    for (String bundlePackagePath : new String[]{packagePath, "WEB-INF/classes/" + packagePath}) {
                        Enumeration<URL> enumeration = bundle.findEntries(bundlePackagePath, "*", false);
                        if (enumeration == null) continue;
                        while (enumeration.hasMoreElements()) {
                            URL url = enumeration.nextElement();
                            String path = url.getPath();
                            String className = (packagePath + path.substring(path.lastIndexOf(47))).replace('/', '.').replace(".class", "");
                            OsgiRegistry.this.classToBundleMapping.put(className, bundle);
                            result.add(url);
                        }
                    }
                    Enumeration<URL> jars = bundle.findEntries("/", "*.jar", true);
                    if (jars == null) continue;
                    while (jars.hasMoreElements()) {
                        try {
                            JarEntry jarEntry;
                            InputStream inputStream = classLoader.getResourceAsStream(jars.nextElement().getPath());
                            JarInputStream jarInputStream = new JarInputStream(inputStream);
                            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                                String jarEntryName = jarEntry.getName();
                                if (!jarEntryName.endsWith(".class") || !jarEntryName.contains(packagePath)) continue;
                                OsgiRegistry.this.classToBundleMapping.put(jarEntryName.replace(".class", "").replace('/', '.'), bundle);
                                result.add(bundle.getResource(jarEntryName));
                            }
                        }
                        catch (Exception exception) {
                        }
                    }
                }
                return Collections.enumeration(result);
            }
        });
    }

    public Class<?> classForNameWithException(String className) throws ClassNotFoundException {
        Bundle bundle = this.classToBundleMapping.get(className);
        if (bundle == null) {
            throw new ClassNotFoundException(className);
        }
        return bundle.loadClass(className);
    }

    private OsgiRegistry(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private void hookUp() {
        this.setOSGiPackageScannerResourceProvider();
        this.setOSGiServiceFinderIteratorProvider();
        this.bundleContext.addBundleListener(this);
        this.registerExistingBundles();
        Bundle jerseyServerBundle = this.getJerseyServerBundle(this.bundleContext);
        RuntimeDelegate runtimeDelegate = null;
        try {
            if (jerseyServerBundle == null) {
                LOGGER.config("jersey-client bundle registers JAX-RS RuntimeDelegate");
                runtimeDelegate = (RuntimeDelegate)this.getClass().getClassLoader().loadClass("com.sun.ws.rs.ext.RuntimeDelegateImpl").newInstance();
            } else {
                LOGGER.config("jersey-server bundle activator registers JAX-RS RuntimeDelegate instance");
                runtimeDelegate = (RuntimeDelegate)this.getClass().getClassLoader().loadClass("ar.sun.jersey.server.impl.provider.RuntimeDelegateImpl").newInstance();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unable to create RuntimeDelegate instance.", e);
        }
        RuntimeDelegate.setInstance(runtimeDelegate);
    }

    private Bundle getJerseyServerBundle(BundleContext bc) {
        for (Bundle b : bc.getBundles()) {
            String symbolicName = b.getSymbolicName();
            if (symbolicName == null || !symbolicName.endsWith("jersey-server") && !symbolicName.endsWith("jersey-gf-server")) continue;
            return b;
        }
        return null;
    }

    private void registerExistingBundles() {
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (bundle.getState() != 4 && bundle.getState() != 8 && bundle.getState() != 32 && bundle.getState() != 16) continue;
            this.register(bundle);
        }
    }

    private void setOSGiServiceFinderIteratorProvider() {
        ServiceFinder.setIteratorProvider(new OsgiServiceFinder());
    }

    private void register(Bundle bundle) {
        Map<String, Callable<List<Class<?>>>> map;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "checking bundle {0}", bundle.getBundleId());
        }
        this.lock.writeLock().lock();
        try {
            map = this.factories.get(bundle.getBundleId());
            if (map == null) {
                map = new ConcurrentHashMap();
                this.factories.put(bundle.getBundleId(), map);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        Enumeration<URL> e = bundle.findEntries("META-INF/services/", "*", false);
        if (e != null) {
            while (e.hasMoreElements()) {
                URL u = e.nextElement();
                String url = u.toString();
                if (url.endsWith("/")) continue;
                String factoryId = url.substring(url.lastIndexOf("/") + 1);
                map.put(factoryId, new BundleSpiProvidersLoader(factoryId, u, bundle));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Class<?>> locateAllProviders(String serviceName) {
        this.lock.readLock().lock();
        try {
            LinkedList result = new LinkedList();
            for (Map<String, Callable<List<Class<?>>>> value : this.factories.values()) {
                if (!value.containsKey(serviceName)) continue;
                try {
                    result.addAll(value.get(serviceName).call());
                }
                catch (Exception exception) {}
            }
            LinkedList linkedList = result;
            return linkedList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private static class BundleSpiProvidersLoader
    implements Callable<List<Class<?>>> {
        private final String spi;
        private final URL spiRegistryUrl;
        private final Bundle bundle;

        BundleSpiProvidersLoader(String spi, URL spiRegistryUrl, Bundle bundle) {
            this.spi = spi;
            this.spiRegistryUrl = spiRegistryUrl;
            this.bundle = bundle;
        }

        @Override
        public List<Class<?>> call() throws Exception {
            try {
                String providerClassName;
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "Loading providers for SPI: {0}", this.spi);
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(this.spiRegistryUrl.openStream(), "UTF-8"));
                ArrayList providerClasses = new ArrayList();
                while ((providerClassName = br.readLine()) != null) {
                    if (providerClassName.trim().length() == 0) continue;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "SPI provider: {0}", providerClassName);
                    }
                    providerClasses.add(this.bundle.loadClass(providerClassName));
                }
                br.close();
                return providerClasses;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "exception caught while creating factories: " + e);
                throw e;
            }
            catch (Error e) {
                LOGGER.log(Level.WARNING, "error caught while creating factories: " + e);
                throw e;
            }
        }

        public String toString() {
            return this.spiRegistryUrl.toString();
        }

        public int hashCode() {
            return this.spiRegistryUrl.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof BundleSpiProvidersLoader) {
                return this.spiRegistryUrl.equals(((BundleSpiProvidersLoader)obj).spiRegistryUrl);
            }
            return false;
        }
    }

    private final class OsgiServiceFinder<T>
    extends ServiceFinder.ServiceIteratorProvider<T> {
        final ServiceFinder.ServiceIteratorProvider defaultIterator = new ServiceFinder.DefaultServiceIteratorProvider();

        private OsgiServiceFinder() {
        }

        @Override
        public Iterator<T> createIterator(final Class<T> serviceClass, final String serviceName, ClassLoader loader, boolean ignoreOnClassNotFound) {
            final List providerClasses = OsgiRegistry.this.locateAllProviders(serviceName);
            if (!providerClasses.isEmpty()) {
                return new Iterator<T>(){
                    Iterator<Class<?>> it;
                    {
                        this.it = providerClasses.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public T next() {
                        Class<?> nextClass = this.it.next();
                        try {
                            return serviceClass.cast(nextClass.newInstance());
                        }
                        catch (Exception ex) {
                            ServiceConfigurationError sce = new ServiceConfigurationError(serviceName + ": " + SpiMessages.PROVIDER_COULD_NOT_BE_CREATED(nextClass.getName(), serviceClass, ex.getLocalizedMessage()));
                            sce.initCause(ex);
                            throw sce;
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
            return this.defaultIterator.createIterator(serviceClass, serviceName, loader, ignoreOnClassNotFound);
        }

        @Override
        public Iterator<Class<T>> createClassIterator(Class<T> service, String serviceName, ClassLoader loader, boolean ignoreOnClassNotFound) {
            final List providerClasses = OsgiRegistry.this.locateAllProviders(serviceName);
            if (!providerClasses.isEmpty()) {
                return new Iterator<Class<T>>(){
                    Iterator<Class<?>> it;
                    {
                        this.it = providerClasses.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public Class<T> next() {
                        return this.it.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
            return this.defaultIterator.createClassIterator(service, serviceName, loader, ignoreOnClassNotFound);
        }
    }
}

