package ar.com.sdd.mercadopago.entity;

import ar.com.sdd.mercadopago.entity.customer.Address;
import ar.com.sdd.mercadopago.entity.customer.DefaultAddress;
import ar.com.sdd.mercadopago.entity.customer.Identification;
import ar.com.sdd.mercadopago.entity.customer.Phone;
import com.google.gson.JsonObject;

import java.util.ArrayList;
import java.util.Date;

/**
 * Mercado Pago SDK
 * Retrieves information about a customer
 * <p>
 * Created by Eduardo Paoletta on 12/15/16.
 */
public class Customer {

    private String id = null;
    private String email = null;
    private String firstName = null;
    private String lastName = null;
    private Phone phone = null;
    private Identification identification = null;
    private String defaultAddress = null;
    private DefaultAddress address = null;
    private Date dateRegistered = null;
    private String description = null;
    private Date dateCreated = null;
    private Date dateLastUpdated = null;
    private JsonObject metadata = null;
    private String defaultCard = null;
    private ArrayList<Card> cards = null;
    private ArrayList<Address> addresses = null;
    private Boolean liveMode = null;


    public String getId() {
        return id;
    }

    public String getEmail() {
        return email;
    }

    public Customer setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getFirstName() {
        return firstName;
    }

    public Customer setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public String getLastName() {
        return lastName;
    }

    public Customer setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public Phone getPhone() {
        return phone;
    }

    public Customer setPhone(Phone phone) {
        this.phone = phone;
        return this;
    }

    public Identification getIdentification() {
        return identification;
    }

    public Customer setIdentification(Identification identification) {
        this.identification = identification;
        return this;
    }

    public String getDefaultAddress() {
        return defaultAddress;
    }

    public Customer setDefaultAddress(String defaultAddress) {
        this.defaultAddress = defaultAddress;
        return this;
    }

    public DefaultAddress getAddress() {
        return address;
    }

    public Customer setAddress(DefaultAddress address) {
        this.address = address;
        return this;
    }

    public Date getDateRegistered() {
        return dateRegistered;
    }

    public Customer setDateRegistered(Date dateRegistered) {
        this.dateRegistered = dateRegistered;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public Customer setDescription(String description) {
        this.description = description;
        return this;
    }

    public Date getDateCreated() {
        return dateCreated;
    }

    public Date getDateLastUpdated() {
        return dateLastUpdated;
    }

    public JsonObject getMetadata() {
        return metadata;
    }

    public Customer setMetadata(JsonObject metadata) {
        this.metadata = metadata;
        return this;
    }

    public String getDefaultCard() {
        return defaultCard;
    }

    public Customer setDefaultCard(String defaultCard) {
        this.defaultCard = defaultCard;
        return this;
    }

    public ArrayList<Card> getCards() {
        return cards;
    }

    public ArrayList<Address> getAddresses() {
        return addresses;
    }

    public Boolean getLiveMode() {
        return liveMode;
    }

}
