package ar.com.sdd.mercadopago.entity;

import ar.com.sdd.mercadopago.entity.merchantorder.Collector;
import ar.com.sdd.mercadopago.entity.merchantorder.Item;
import ar.com.sdd.mercadopago.entity.merchantorder.MerchantOrderPayment;
import ar.com.sdd.mercadopago.entity.merchantorder.Payer;
import ar.com.sdd.mercadopago.entity.merchantorder.Shipment;

import java.util.ArrayList;
import java.util.Date;

/**
 * Mercado Pago MercadoPago
 * This resource allows you to keep  the state of an order, grouping items, payments and shipments.
 * <p>
 * Created by Eduardo Paoletta on 12/13/16.
 */
public class MerchantOrder {

    private String id = null;
    private String preferenceId = null;
    private Date dateCreated = null;
    private Date lastUpdate = null;
    private String applicationId = null;
    private String status = null;
    private String siteId = null;
    private Payer payer = null;
    private Collector collector = null;
    private Integer sponsorId = null;
    private ArrayList<MerchantOrderPayment> payments = null;
    private Float paidAmount = null;
    private Float refundedAmount = null;
    private Float shippingCost = null;
    private Boolean cancelled = null;
    private ArrayList<Item> items = null;
    private ArrayList<Shipment> shipments = null;
    private String notificationUrl = null;
    private String additionalInfo = null;
    private String externalReference = null;
    private String marketplace = null;
    private Float totalAmount = null;


    public String getId() {
        return id;
    }

    public String getPreferenceId() {
        return preferenceId;
    }

    public MerchantOrder setPreferenceId(String preferenceId) {
        this.preferenceId = preferenceId;
        return this;
    }

    public Date getDateCreated() {
        return dateCreated;
    }

    public Date getLastUpdate() {
        return lastUpdate;
    }

    public String getApplicationId() {
        return applicationId;
    }

    public MerchantOrder setApplicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public String getStatus() {
        return status;
    }

    public String getSiteId() {
        return siteId;
    }

    public MerchantOrder setSiteId(String siteId) {
        this.siteId = siteId;
        return this;
    }

    public Payer getPayer() {
        return payer;
    }

    public MerchantOrder setPayer(Payer payer) {
        this.payer = payer;
        return this;
    }

    public Collector getCollector() {
        return collector;
    }

    public MerchantOrder setCollector(Collector collector) {
        this.collector = collector;
        return this;
    }

    public Integer getSponsorId() {
        return sponsorId;
    }

    public MerchantOrder setSponsorId(Integer sponsorId) {
        this.sponsorId = sponsorId;
        return this;
    }

    public ArrayList<MerchantOrderPayment> getPayments() {
        return payments;
    }

    public Float getPaidAmount() {
        return paidAmount;
    }

    public Float getRefundedAmount() {
        return refundedAmount;
    }

    public Float getShippingCost() {
        return shippingCost;
    }

    public Boolean getCancelled() {
        return cancelled;
    }

    public MerchantOrder setCancelled(Boolean cancelled) {
        this.cancelled = cancelled;
        return this;
    }

    public ArrayList<Item> getItems() {
        return items;
    }

    public MerchantOrder setItems(ArrayList<Item> items) {
        this.items = items;
        return this;
    }

    public MerchantOrder appendItem(Item item) {
        if (items == null) {
            items = new ArrayList<Item>();
        }
        items.add(item);
        return this;
    }

    public ArrayList<Shipment> getShipments() {
        return shipments;
    }

    public MerchantOrder setShipments(ArrayList<Shipment> shipments) {
        this.shipments = shipments;
        return this;
    }

    public MerchantOrder appendShipment(Shipment shipment) {
        if (shipments == null) {
            shipments = new ArrayList<Shipment>();
        }
        shipments.add(shipment);
        return this;
    }

    public String getNotificationUrl() {
        return notificationUrl;
    }

    public MerchantOrder setNotificationUrl(String notificationUrl) {
        this.notificationUrl = notificationUrl;
        return this;
    }

    public String getAdditionalInfo() {
        return additionalInfo;
    }

    public MerchantOrder setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
        return this;
    }

    public String getExternalReference() {
        return externalReference;
    }

    public MerchantOrder setExternalReference(String externalReference) {
        this.externalReference = externalReference;
        return this;
    }

    public String getMarketplace() {
        return marketplace;
    }

    public MerchantOrder setMarketplace(String marketplace) {
        this.marketplace = marketplace;
        return this;
    }

    public Float getTotalAmount() {
        return totalAmount;
    }


}
