package ar.com.sdd.mercadopago.entity.customer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

/**
 * Mercado Pago SDK
 * Customer Address class
 * <p>
 * Created by Eduardo Paoletta on 12/15/16.
 */
public class Address {

    private String id = null;
    private String phone = null;
    private String name = null;
    private String floor = null;
    private String apartment = null;
    private String streetName = null;
    private String streetNumber = null;
    private String zipCode = null;
    private City city = null;
    private State state = null;
    private Country country = null;
    private Neighborhood neighborhood = null;
    private Municipality municipality = null;
    private String comments = null;
    private Date dateCreated = null;
    private ArrayList<Verification> verifications = null;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFloor() {
        return floor;
    }

    public void setFloor(String floor) {
        this.floor = floor;
    }

    public String getApartment() {
        return apartment;
    }

    public void setApartment(String apartment) {
        this.apartment = apartment;
    }

    public String getStreetName() {
        return streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    public String getStreetNumber() {
        return streetNumber;
    }

    public void setStreetNumber(String streetNumber) {
        this.streetNumber = streetNumber;
    }

    public String getZipCode() {
        return zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public City getCity() {
        return city;
    }

    public void setCity(City city) {
        this.city = city;
    }

    public State getState() {
        return state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Country getCountry() {
        return country;
    }

    public void setCountry(Country country) {
        this.country = country;
    }

    public Neighborhood getNeighborhood() {
        return neighborhood;
    }

    public void setNeighborhood(Neighborhood neighborhood) {
        this.neighborhood = neighborhood;
    }

    public Municipality getMunicipality() {
        return municipality;
    }

    public void setMunicipality(Municipality municipality) {
        this.municipality = municipality;
    }

    public String getComments() {
        return comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Date getDateCreated() {
        return dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public ArrayList<Verification> getVerifications() {
        return verifications;
    }

    public void setVerifications(ArrayList<Verification> verifications) {
        this.verifications = verifications;
    }

    @Override
    public String toString() {
        return "Address ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((phone != null) ? "phone=" + phone + ", " : "")
                + ((name != null) ? "name=" + name + ", " : "")
                + ((floor != null) ? "floor=" + floor + ", " : "")
                + ((apartment != null) ? "apartment=" + apartment + ", " : "")
                + ((streetName != null) ? "streetName=" + streetName + ", " : "")
                + ((streetNumber != null) ? "streetNumber=" + streetNumber + ", " : "")
                + ((zipCode != null) ? "zipCode=" + zipCode + ", " : "")
                + ((city != null) ? "city=" + city + ", " : "")
                + ((state != null) ? "state=" + state + ", " : "")
                + ((country != null) ? "country=" + country + ", " : "")
                + ((neighborhood != null) ? "neighborhood=" + neighborhood + ", " : "")
                + ((municipality != null) ? "municipality=" + municipality + ", " : "")
                + ((comments != null) ? "comments=" + comments + ", " : "")
                + ((dateCreated != null) ? "dateCreated=" + dateCreated + ", " : "")
                + ((verifications != null) ? "verifications=" + Arrays.toString(verifications.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Address address = (Address) o;

        if (id != null ? !id.equals(address.id) : address.id != null) return false;
        if (phone != null ? !phone.equals(address.phone) : address.phone != null) return false;
        if (name != null ? !name.equals(address.name) : address.name != null) return false;
        if (floor != null ? !floor.equals(address.floor) : address.floor != null) return false;
        if (apartment != null ? !apartment.equals(address.apartment) : address.apartment != null) return false;
        if (streetName != null ? !streetName.equals(address.streetName) : address.streetName != null) return false;
        if (streetNumber != null ? !streetNumber.equals(address.streetNumber) : address.streetNumber != null) return false;
        if (zipCode != null ? !zipCode.equals(address.zipCode) : address.zipCode != null) return false;
        if (city != null ? !city.equals(address.city) : address.city != null) return false;
        if (state != null ? !state.equals(address.state) : address.state != null) return false;
        if (country != null ? !country.equals(address.country) : address.country != null) return false;
        if (neighborhood != null ? !neighborhood.equals(address.neighborhood) : address.neighborhood != null) return false;
        if (municipality != null ? !municipality.equals(address.municipality) : address.municipality != null) return false;
        if (comments != null ? !comments.equals(address.comments) : address.comments != null) return false;
        if (dateCreated != null ? !dateCreated.equals(address.dateCreated) : address.dateCreated != null) return false;
        return verifications != null ? verifications.equals(address.verifications) : address.verifications == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (phone != null ? phone.hashCode() : 0);
        result = 31 * result + (name != null ? name.hashCode() : 0);
        result = 31 * result + (floor != null ? floor.hashCode() : 0);
        result = 31 * result + (apartment != null ? apartment.hashCode() : 0);
        result = 31 * result + (streetName != null ? streetName.hashCode() : 0);
        result = 31 * result + (streetNumber != null ? streetNumber.hashCode() : 0);
        result = 31 * result + (zipCode != null ? zipCode.hashCode() : 0);
        result = 31 * result + (city != null ? city.hashCode() : 0);
        result = 31 * result + (state != null ? state.hashCode() : 0);
        result = 31 * result + (country != null ? country.hashCode() : 0);
        result = 31 * result + (neighborhood != null ? neighborhood.hashCode() : 0);
        result = 31 * result + (municipality != null ? municipality.hashCode() : 0);
        result = 31 * result + (comments != null ? comments.hashCode() : 0);
        result = 31 * result + (dateCreated != null ? dateCreated.hashCode() : 0);
        result = 31 * result + (verifications != null ? verifications.hashCode() : 0);
        return result;
    }
}
